/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.util.FailableFunction;

public interface ElevationFunction {
    public static ElevationFunction ifNotRoot(final ElevationFunction function) {
        return new ElevationFunction(){

            @Override
            public String getPrefix() {
                return function.getPrefix();
            }

            @Override
            public boolean isSpecified() {
                return true;
            }

            @Override
            public boolean apply(ShellControl shellControl) throws Exception {
                if (shellControl.getOsType() == OsType.WINDOWS) {
                    return false;
                }
                boolean isRoot = shellControl.executeSimpleBooleanCommand("test \"${EUID:-$(id -u)}\" -eq 0");
                if (isRoot) {
                    return false;
                }
                return function.apply(shellControl);
            }
        };
    }

    public static ElevationFunction of(final String prefix, final FailableFunction<ShellControl, Boolean, Exception> f) {
        return new ElevationFunction(){

            @Override
            public String getPrefix() {
                return prefix;
            }

            @Override
            public boolean isSpecified() {
                return true;
            }

            @Override
            public boolean apply(ShellControl shellControl) throws Exception {
                return (Boolean)f.apply(shellControl);
            }
        };
    }

    public static ElevationFunction elevated(final String prefix) {
        return new ElevationFunction(){

            @Override
            public String getPrefix() {
                return prefix;
            }

            @Override
            public boolean isSpecified() {
                return true;
            }

            @Override
            public boolean apply(ShellControl shellControl) {
                return true;
            }
        };
    }

    public static ElevationFunction none() {
        return new ElevationFunction(){

            @Override
            public String getPrefix() {
                return null;
            }

            @Override
            public boolean isSpecified() {
                return false;
            }

            @Override
            public boolean apply(ShellControl shellControl) {
                return false;
            }
        };
    }

    public String getPrefix();

    public boolean isSpecified();

    public boolean apply(ShellControl var1) throws Exception;
}

