/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.CountDown;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FilePath;
import io.xpipe.core.util.FailableConsumer;
import io.xpipe.core.util.FailableFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.UUID;
import java.util.function.Function;

public class CommandBuilder {
    private final List<Element> elements = new ArrayList<Element>();
    private final Map<String, Element> environmentVariables = new LinkedHashMap<String, Element>();
    private final List<FailableConsumer<ShellControl, Exception>> setup = new ArrayList<FailableConsumer<ShellControl, Exception>>();
    private CountDown countDown;
    private UUID uuid;

    private CommandBuilder() {
    }

    public static CommandBuilder of() {
        return new CommandBuilder();
    }

    public static CommandBuilder ofString(String s) {
        return new CommandBuilder().add(s);
    }

    public static CommandBuilder ofFunction(FailableFunction<ShellControl, String, Exception> command) {
        return CommandBuilder.of().add((ShellControl sc) -> (String)command.apply(sc));
    }

    public CommandBuilder setup(FailableConsumer<ShellControl, Exception> consumer) {
        this.setup.add(consumer);
        return this;
    }

    public CommandBuilder fixedEnvrironment(String k, String v) {
        this.environmentVariables.put(k, new Fixed(v));
        return this;
    }

    public CommandBuilder envrironment(String k, Element v) {
        this.environmentVariables.put(k, v);
        return this;
    }

    public CommandBuilder fixedEnvrironment(Map<String, String> map) {
        map.forEach((s, s2) -> this.fixedEnvrironment((String)s, (String)s2));
        return this;
    }

    public CommandBuilder envrironment(Map<String, Element> map) {
        this.environmentVariables.putAll(map);
        return this;
    }

    public CommandBuilder discardOutput() {
        this.elements.add(sc -> sc.getShellDialect().getDiscardOperator());
        return this;
    }

    public CommandBuilder addSeparator(String s) {
        this.elements.add(sc -> sc.getShellDialect().getConcatenationOperator());
        return this;
    }

    public CommandBuilder addIf(boolean b, String ... s) {
        if (b) {
            for (String s1 : s) {
                this.elements.add(new Fixed(s1));
            }
        }
        return this;
    }

    public CommandBuilder add(String ... s) {
        for (String s1 : s) {
            this.elements.add(new Fixed(s1));
        }
        return this;
    }

    public CommandBuilder add(int index, String ... s) {
        for (String s1 : s) {
            this.elements.add(index++, new Fixed(s1));
        }
        return this;
    }

    public CommandBuilder add(int index, Element ... s) {
        for (Element s1 : s) {
            this.elements.add(index++, s1);
        }
        return this;
    }

    public CommandBuilder remove(String s) {
        this.elements.removeIf(element -> {
            if (!(element instanceof Fixed)) return false;
            Fixed fixed = (Fixed)element;
            if (!s.equals(fixed.string)) return false;
            return true;
        });
        return this;
    }

    public CommandBuilder addQuoted(String s) {
        this.elements.add(sc -> {
            if (s == null) {
                return null;
            }
            if (sc == null) {
                return "\"" + s + "\"";
            }
            return sc.getShellDialect().quoteArgument(s);
        });
        return this;
    }

    public CommandBuilder addQuoted(int index, String s) {
        this.elements.add(index, sc -> {
            if (s == null) {
                return null;
            }
            if (sc == null) {
                return "\"" + s + "\"";
            }
            return sc.getShellDialect().quoteArgument(s);
        });
        return this;
    }

    public CommandBuilder add(CommandBuilder sub) {
        this.elements.addAll(sub.elements);
        this.environmentVariables.putAll(sub.environmentVariables);
        return this;
    }

    public CommandBuilder prepend(Element e) {
        this.elements.addFirst(e);
        return this;
    }

    public CommandBuilder add(Element e) {
        this.elements.add(e);
        return this;
    }

    public CommandBuilder addAll(List<String> s) {
        for (String s1 : s) {
            this.elements.add(new Fixed(s1));
        }
        return this;
    }

    public CommandBuilder addAll(FailableFunction<ShellControl, List<String>, Exception> f) {
        this.elements.add(sc -> String.join((CharSequence)" ", (Iterable)f.apply(sc)));
        return this;
    }

    public CommandBuilder prepend(String ... s) {
        this.elements.addAll(0, Arrays.stream(s).map(s2 -> new Fixed((String)s2)).toList());
        return this;
    }

    public CommandBuilder prependQuoted(String s) {
        return this.prepend("\"" + s + "\"");
    }

    public CommandBuilder addFile(Function<ShellControl, String> f) {
        this.elements.add(sc -> {
            if (f == null) {
                return null;
            }
            if (sc == null) {
                return "\"" + (String)f.apply(null) + "\"";
            }
            return sc.getShellDialect().fileArgument((String)f.apply(sc));
        });
        return this;
    }

    public CommandBuilder addFile(String s) {
        this.elements.add(sc -> {
            if (s == null) {
                return null;
            }
            if (sc == null) {
                return "\"" + s + "\"";
            }
            return sc.getShellDialect().fileArgument(s);
        });
        return this;
    }

    public CommandBuilder addFile(FilePath s) {
        return this.addFile(s.toString());
    }

    public CommandBuilder addLiteral(String s) {
        this.elements.add(sc -> {
            if (s == null) {
                return null;
            }
            if (sc == null) {
                return "\"" + s + "\"";
            }
            return sc.getShellDialect().literalArgument(s);
        });
        return this;
    }

    public CommandBuilder addFiles(SequencedCollection<String> s) {
        s.forEach(this::addFile);
        return this;
    }

    public String buildBase(ShellControl sc) throws Exception {
        return String.join((CharSequence)" ", this.buildBaseParts(sc));
    }

    public List<String> buildBaseParts(ShellControl sc) throws Exception {
        this.countDown = CountDown.of();
        this.uuid = UUID.randomUUID();
        for (FailableConsumer<ShellControl, Exception> s : this.setup) {
            s.accept(sc);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Element element : this.elements) {
            String evaluate = element.evaluate(sc);
            if (evaluate == null) continue;
            list.add(evaluate);
        }
        return list;
    }

    public String buildFull(ShellControl sc) throws Exception {
        String s = this.buildBase(sc);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Element> e : this.environmentVariables.entrySet()) {
            String v = e.getValue().evaluate(sc);
            if (v == null) continue;
            map.put(e.getKey(), v);
        }
        return sc.getShellDialect().assembleCommand(s, map);
    }

    public CommandControl build(ShellControl sc) {
        return sc.command(this);
    }

    public String buildSimple() {
        ArrayList<String> list = new ArrayList<String>();
        for (Element element : this.elements) {
            String evaluate = element.evaluate(null);
            if (evaluate == null) continue;
            list.add(evaluate);
        }
        return String.join((CharSequence)" ", list);
    }

    public Map<String, Element> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public CountDown getCountDown() {
        return this.countDown;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static interface Element {
        public String evaluate(ShellControl var1) throws Exception;
    }

    static class Fixed
    implements Element {
        private final String string;

        Fixed(String string) {
            this.string = string;
        }

        @Override
        public String evaluate(ShellControl sc) {
            return this.string;
        }
    }
}

