/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.dialog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.dialog.DialogElement;

@JsonTypeName(value="query")
public class BaseQueryElement
extends DialogElement {
    private final String description;
    private final boolean newLine;
    private final boolean required;
    private final boolean secret;
    private final boolean quiet;
    protected String value;

    @JsonCreator
    public BaseQueryElement(String description, boolean newLine, boolean required, boolean secret, boolean quiet, String value) {
        this.description = description;
        this.newLine = newLine;
        this.required = required;
        this.secret = secret;
        this.quiet = quiet;
        this.value = value;
    }

    @Override
    public String toDisplayString() {
        return this.description;
    }

    @Override
    public boolean requiresExplicitUserInput() {
        return this.required && this.value == null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseQueryElement)) {
            return false;
        }
        BaseQueryElement other = (BaseQueryElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isNewLine() != other.isNewLine()) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        if (this.isSecret() != other.isSecret()) {
            return false;
        }
        if (this.isQuiet() != other.isQuiet()) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseQueryElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isNewLine() ? 79 : 97);
        result = result * 59 + (this.isRequired() ? 79 : 97);
        result = result * 59 + (this.isSecret() ? 79 : 97);
        result = result * 59 + (this.isQuiet() ? 79 : 97);
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BaseQueryElement(description=" + this.getDescription() + ", newLine=" + this.isNewLine() + ", required=" + this.isRequired() + ", secret=" + this.isSecret() + ", quiet=" + this.isQuiet() + ", value=" + this.getValue() + ")";
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isNewLine() {
        return this.newLine;
    }
}

