/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.impl.FileNames;
import io.xpipe.core.process.ShellControl;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;

public class XPipeSystemId {
    private static UUID localId;

    public static void init() {
        try {
            Path file = Path.of(System.getProperty("user.home"), new String[0]).resolve(".xpipe").resolve("system_id");
            if (!Files.exists(file, new LinkOption[0])) {
                Files.writeString(file, (CharSequence)UUID.randomUUID().toString(), new OpenOption[0]);
            }
            localId = UUID.fromString(Files.readString(file).trim());
        }
        catch (Exception ex) {
            localId = UUID.randomUUID();
        }
    }

    public static UUID getLocal() {
        return localId;
    }

    public static UUID getSystemId(ShellControl proc) throws Exception {
        String file = proc.getOsType().getSystemIdFile(proc);
        if (file == null) {
            return UUID.randomUUID();
        }
        if (!proc.getShellDialect().createFileExistsCommand(proc, file).executeAndCheck()) {
            return XPipeSystemId.writeRandom(proc, file);
        }
        try {
            return UUID.fromString(proc.executeSimpleStringCommand(proc.getShellDialect().getFileReadCommand(file)).trim());
        }
        catch (IllegalArgumentException ex) {
            return XPipeSystemId.writeRandom(proc, file);
        }
    }

    private static UUID writeRandom(ShellControl proc, String file) throws Exception {
        proc.executeSimpleCommand(proc.getShellDialect().getMkdirsCommand(FileNames.getParent(file)), "Unable to access or create directory " + file);
        UUID id = UUID.randomUUID();
        proc.getShellDialect().createTextFileWriteCommand(proc, id.toString(), file).execute();
        return id;
    }
}

