/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.impl.FileNames;
import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ProcessOutputException;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.util.ModuleHelper;
import io.xpipe.core.util.XPipeDaemonMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class XPipeInstallation {
    public static String createExternalAsyncLaunchCommand(String installationBase, XPipeDaemonMode mode, String arguments) {
        Object suffix;
        Object object = suffix = arguments != null ? " " + arguments : "";
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return "nohup \"" + installationBase + "/app/bin/xpiped\" --mode " + mode.getDisplayName() + (String)suffix + " & disown";
        }
        if (OsType.getLocal().equals(OsType.MACOS)) {
            return "open \"" + installationBase + "\" --args --mode " + mode.getDisplayName() + (String)suffix;
        }
        return "\"" + FileNames.join(installationBase, XPipeInstallation.getDaemonExecutablePath(OsType.getLocal())) + "\" --mode " + mode.getDisplayName() + (String)suffix;
    }

    public static String createExternalLaunchCommand(String command, String arguments, XPipeDaemonMode mode) {
        Object suffix = arguments != null ? " " + arguments : "";
        return "\"" + command + "\" --mode " + mode.getDisplayName() + (String)suffix;
    }

    public static Path getCurrentInstallationBasePath() {
        String name;
        Path path = Path.of(ProcessHandle.current().info().command().orElseThrow(), new String[0]).toRealPath(new LinkOption[0]);
        if (!path.isAbsolute()) {
            path = Path.of(System.getProperty("user.dir"), new String[0]).resolve(path).toRealPath(new LinkOption[0]);
        }
        if ((name = path.getFileName().toString()).endsWith("java") || name.endsWith("java.exe")) {
            boolean isImage = ModuleHelper.isImage();
            if (!isImage) {
                return Path.of(System.getProperty("user.dir"), new String[0]);
            }
            return XPipeInstallation.getLocalInstallationBasePathForJavaExecutable(path);
        }
        return XPipeInstallation.getLocalInstallationBasePathForDaemonExecutable(path);
    }

    public static boolean isInstallationDistribution() {
        Path base = XPipeInstallation.getCurrentInstallationBasePath();
        if (OsType.getLocal().equals(OsType.MACOS)) {
            if (!base.toString().equals(XPipeInstallation.getLocalDefaultInstallationBasePath(false))) {
                return false;
            }
            try {
                Process process = new ProcessBuilder("pkgutil", "--pkg-info", "io.xpipe.xpipe").redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD).start();
                process.waitFor();
                return process.exitValue() == 0;
            }
            catch (Exception ex) {
                return false;
            }
        }
        Path file = base.resolve("installation");
        return Files.exists(file, new LinkOption[0]);
    }

    public static Path getLocalDynamicLibraryDirectory() {
        Path path = XPipeInstallation.getCurrentInstallationBasePath();
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            return path.resolve("app").resolve("runtime").resolve("bin");
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return path.resolve("app").resolve("lib").resolve("runtime").resolve("lib");
        }
        return path.resolve("Contents").resolve("runtime").resolve("Contents").resolve("Home").resolve("lib");
    }

    public static Path getLocalExtensionsDirectory(Path path) {
        return OsType.getLocal().equals(OsType.MACOS) ? path.resolve("Contents").resolve("Resources").resolve("extensions") : path.resolve("app").resolve("extensions");
    }

    private static Path getLocalInstallationBasePathForJavaExecutable(Path executable) {
        if (OsType.getLocal().equals(OsType.MACOS)) {
            return executable.getParent().getParent().getParent().getParent().getParent().getParent();
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return executable.getParent().getParent().getParent().getParent().getParent();
        }
        return executable.getParent().getParent().getParent().getParent();
    }

    private static Path getLocalInstallationBasePathForDaemonExecutable(Path executable) {
        if (OsType.getLocal().equals(OsType.MACOS)) {
            return executable.getParent().getParent().getParent();
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return executable.getParent().getParent().getParent();
        }
        return executable.getParent().getParent();
    }

    public static String getLocalInstallationBasePathForCLI(String cliExecutable) {
        String defaultInstallation = XPipeInstallation.getLocalDefaultInstallationBasePath(true);
        if (cliExecutable == null) {
            return defaultInstallation;
        }
        if (OsType.getLocal().equals(OsType.LINUX) && cliExecutable.equals("/usr/bin/xpipe")) {
            return defaultInstallation;
        }
        Path path = Path.of(cliExecutable, new String[0]);
        if (OsType.getLocal().equals(OsType.MACOS)) {
            return path.getParent().getParent().getParent().toString();
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return path.getParent().getParent().getParent().toString();
        }
        return path.getParent().getParent().getParent().toString();
    }

    public static String queryLocalInstallationVersion(String exec) throws Exception {
        Process process = new ProcessBuilder(exec, "version").redirectError(ProcessBuilder.Redirect.DISCARD).start();
        String v = new String(process.getInputStream().readAllBytes(), StandardCharsets.US_ASCII);
        process.waitFor();
        return v;
    }

    public static String queryInstallationVersion(ShellControl p, String exec) throws Exception {
        String string;
        block8: {
            CommandControl c = p.command(List.of(exec, "version")).start();
            try {
                string = c.readStdoutOrThrow();
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessOutputException ex) {
                    return "?";
                }
            }
            c.close();
        }
        return string;
    }

    public static String getInstallationExecutable(ShellControl p, String installation) {
        String executable = XPipeInstallation.getDaemonExecutablePath(p.getOsType());
        String file = FileNames.join(installation, executable);
        return file;
    }

    public static String getDataBasePath(ShellControl p) throws Exception {
        if (p.getOsType().equals(OsType.WINDOWS)) {
            String base = p.executeSimpleStringCommand(p.getShellDialect().getPrintVariableCommand("userprofile"));
            return FileNames.join(base, ".xpipe");
        }
        return FileNames.join("~", ".xpipe");
    }

    public static String getLocalDefaultCliExecutable() {
        Path path = ModuleHelper.isImage() ? XPipeInstallation.getCurrentInstallationBasePath() : Path.of(XPipeInstallation.getLocalDefaultInstallationBasePath(true), new String[0]);
        return path.resolve(XPipeInstallation.getRelativeCliExecutablePath(OsType.getLocal())).toString();
    }

    public static Path getLocalDefaultInstallationIcon() {
        Path path = XPipeInstallation.getCurrentInstallationBasePath();
        if (!ModuleHelper.isImage()) {
            if (OsType.getLocal().equals(OsType.WINDOWS)) {
                return path.resolve("dist").resolve("logo").resolve("logo.ico");
            }
            if (OsType.getLocal().equals(OsType.LINUX)) {
                return path.resolve("dist").resolve("logo").resolve("logo.png");
            }
            return path.resolve("dist").resolve("logo").resolve("logo.icns");
        }
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            return path.resolve("app").resolve("logo.ico");
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return path.resolve("logo.png");
        }
        return path.resolve("Contents").resolve("Resources").resolve("logo.icns");
    }

    public static String getLocalDefaultInstallationBasePath(boolean acceptCustomHome) {
        String path;
        String customHome = System.getenv("XPIPE_HOME");
        if (customHome != null && !customHome.isEmpty() && acceptCustomHome) {
            return customHome;
        }
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            String base = System.getenv("LOCALAPPDATA");
            path = FileNames.join(base, "XPipe");
        } else {
            path = OsType.getLocal().equals(OsType.LINUX) ? "/opt/xpipe" : "/Applications/XPipe.app";
        }
        return path;
    }

    public static String getDefaultInstallationBasePath(ShellControl p, boolean acceptPortable) throws Exception {
        String path;
        String customHome;
        if (acceptPortable && !(customHome = p.executeSimpleStringCommand(p.getShellDialect().getPrintVariableCommand("XPIPE_HOME"))).isEmpty()) {
            return customHome;
        }
        if (p.getOsType().equals(OsType.WINDOWS)) {
            String base = p.executeSimpleStringCommand(p.getShellDialect().getPrintVariableCommand("LOCALAPPDATA"));
            path = FileNames.join(base, "XPipe");
        } else {
            path = p.getOsType().equals(OsType.LINUX) ? "/opt/xpipe" : "/Applications/XPipe.app";
        }
        return path;
    }

    public static String getDaemonDebugScriptPath(OsType type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "scripts", "xpiped_debug.bat");
        }
        if (type.equals(OsType.LINUX)) {
            return FileNames.join("app", "scripts", "xpiped_debug.sh");
        }
        return FileNames.join("Contents", "Resources", "scripts", "xpiped_debug.sh");
    }

    public static String getDaemonDebugAttachScriptPath(OsType type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "scripts", "xpiped_debug_attach.bat");
        }
        if (type.equals(OsType.LINUX)) {
            return FileNames.join("app", "scripts", "xpiped_debug_attach.sh");
        }
        return FileNames.join("Contents", "Resources", "scripts", "xpiped_debug_attach.sh");
    }

    public static String getDaemonExecutablePath(OsType type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "xpiped.exe");
        }
        if (type.equals(OsType.LINUX)) {
            return FileNames.join("app", "bin", "xpiped");
        }
        return FileNames.join("Contents", "MacOS", "xpiped");
    }

    public static String getRelativeCliExecutablePath(OsType type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("cli", "bin", "xpipe.exe");
        }
        if (type.equals(OsType.LINUX)) {
            return FileNames.join("cli", "bin", "xpipe");
        }
        return FileNames.join("Contents", "MacOS", "xpipe");
    }
}

