/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.xpipe.core.store.ShellStore;
import io.xpipe.core.util.JacksonMapper;
import io.xpipe.core.util.ProxyProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;

public abstract class ProxyFunction {
    private static ModuleLayer layer;

    public static void init(ModuleLayer l) {
        layer = l;
    }

    public ProxyFunction callAndCopy() {
        ShellStore proxyStore = ProxyProvider.get().getProxy(this.getProxyBase());
        if (proxyStore != null) {
            return ProxyProvider.get().call(this, proxyStore);
        }
        this.callLocal();
        return this;
    }

    protected Object getProxyBase() {
        Field first = Arrays.stream(this.getClass().getDeclaredFields()).findFirst().orElseThrow();
        first.setAccessible(true);
        return first.get(this);
    }

    public abstract void callLocal();

    public static class Deserializer
    extends StdDeserializer<ProxyFunction> {
        protected Deserializer() {
            super(ProxyFunction.class);
        }

        public ProxyFunction deserialize(JsonParser p, DeserializationContext ctxt) {
            ObjectNode tree = (ObjectNode)JacksonMapper.getDefault().readTree(p);
            String moduleReference = tree.remove("module").asText();
            String classReference = tree.remove("class").asText();
            Module module = layer.findModule(moduleReference).orElseThrow();
            Class<?> targetClass = Class.forName(module, classReference);
            if (targetClass == null) {
                throw new IllegalArgumentException("Named function class not found: " + classReference);
            }
            return (ProxyFunction)JacksonMapper.getDefault().treeToValue((TreeNode)tree, targetClass);
        }
    }

    public static class Serializer
    extends StdSerializer<ProxyFunction> {
        protected Serializer() {
            super(ProxyFunction.class);
        }

        public void serialize(ProxyFunction value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            ObjectNode node = (ObjectNode)JacksonMapper.getDefault().valueToTree((Object)value);
            node.set("module", (JsonNode)new TextNode(value.getClass().getModule().getName()));
            node.set("class", (JsonNode)new TextNode(value.getClass().getName()));
            gen.writeTree((TreeNode)node);
        }
    }
}

