/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.util.SecretValue;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;

@JsonDeserialize(builder=EncryptedSecretValueBuilderImpl.class)
public class EncryptedSecretValue
implements SecretValue {
    String encryptedValue;

    public EncryptedSecretValue(char[] c) {
        ByteBuffer utf8 = StandardCharsets.UTF_8.encode(CharBuffer.wrap(c));
        byte[] bytes = new byte[utf8.limit()];
        utf8.get(bytes);
        this.encryptedValue = SecretValue.toBase64e(this.encrypt(bytes));
    }

    public String toString() {
        return "<encrypted secret>";
    }

    @Override
    public char[] getSecret() {
        try {
            byte[] bytes = SecretValue.fromBase64e(this.getEncryptedValue());
            bytes = this.decrypt(bytes);
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes));
            char[] chars = new char[charBuffer.limit()];
            charBuffer.get(chars);
            return chars;
        }
        catch (Exception ex) {
            return new char[0];
        }
    }

    public byte[] encrypt(byte[] c) {
        throw new UnsupportedOperationException();
    }

    public byte[] decrypt(byte[] c) {
        throw new UnsupportedOperationException();
    }

    protected EncryptedSecretValue(EncryptedSecretValueBuilder<?, ?> b) {
        this.encryptedValue = b.encryptedValue;
    }

    public static EncryptedSecretValueBuilder<?, ?> builder() {
        return new EncryptedSecretValueBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptedSecretValue)) {
            return false;
        }
        EncryptedSecretValue other = (EncryptedSecretValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$encryptedValue = this.getEncryptedValue();
        String other$encryptedValue = other.getEncryptedValue();
        return !(this$encryptedValue == null ? other$encryptedValue != null : !this$encryptedValue.equals(other$encryptedValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptedSecretValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encryptedValue = this.getEncryptedValue();
        result = result * 59 + ($encryptedValue == null ? 43 : $encryptedValue.hashCode());
        return result;
    }

    public String getEncryptedValue() {
        return this.encryptedValue;
    }

    public static abstract class EncryptedSecretValueBuilder<C extends EncryptedSecretValue, B extends EncryptedSecretValueBuilder<C, B>> {
        private String encryptedValue;

        public B encryptedValue(String encryptedValue) {
            this.encryptedValue = encryptedValue;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "EncryptedSecretValue.EncryptedSecretValueBuilder(encryptedValue=" + this.encryptedValue + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class EncryptedSecretValueBuilderImpl
    extends EncryptedSecretValueBuilder<EncryptedSecretValue, EncryptedSecretValueBuilderImpl> {
        private EncryptedSecretValueBuilderImpl() {
        }

        @Override
        protected EncryptedSecretValueBuilderImpl self() {
            return this;
        }

        @Override
        public EncryptedSecretValue build() {
            return new EncryptedSecretValue(this);
        }
    }
}

