/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.util.EncryptedSecretValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

@JsonDeserialize(builder=AesSecretValueBuilderImpl.class)
public class AesSecretValue
extends EncryptedSecretValue {
    private static final String ENCRYPT_ALGO = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int IV_LENGTH_BYTE = 12;
    private static final int AES_KEY_BIT = 128;
    private static final byte[] IV = AesSecretValue.getFixedNonce(12);

    public AesSecretValue(char[] secret) {
        super(secret);
    }

    private static byte[] getFixedNonce(int numBytes) {
        byte[] nonce = new byte[numBytes];
        new Random(213186L).nextBytes(nonce);
        return nonce;
    }

    protected SecretKey getAESKey(int keysize) throws NoSuchAlgorithmException, InvalidKeySpecException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] encrypt(byte[] c) {
        SecretKey secretKey = this.getAESKey(128);
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
        cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, IV));
        byte[] bytes = cipher.doFinal(c);
        bytes = ByteBuffer.allocate(IV.length + bytes.length).order(ByteOrder.LITTLE_ENDIAN).put(IV).put(bytes).array();
        return bytes;
    }

    @Override
    public byte[] decrypt(byte[] c) {
        ByteBuffer bb = ByteBuffer.wrap(c).order(ByteOrder.LITTLE_ENDIAN);
        byte[] iv = new byte[12];
        bb.get(iv);
        byte[] cipherText = new byte[bb.remaining()];
        bb.get(cipherText);
        SecretKey secretKey = this.getAESKey(128);
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
        cipher.init(2, (Key)secretKey, new GCMParameterSpec(128, iv));
        return cipher.doFinal(cipherText);
    }

    protected AesSecretValue(AesSecretValueBuilder<?, ?> b) {
        super(b);
    }

    public static AesSecretValueBuilder<?, ?> builder() {
        return new AesSecretValueBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AesSecretValue)) {
            return false;
        }
        AesSecretValue other = (AesSecretValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AesSecretValue;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class AesSecretValueBuilderImpl
    extends AesSecretValueBuilder<AesSecretValue, AesSecretValueBuilderImpl> {
        private AesSecretValueBuilderImpl() {
        }

        @Override
        protected AesSecretValueBuilderImpl self() {
            return this;
        }

        @Override
        public AesSecretValue build() {
            return new AesSecretValue(this);
        }
    }

    public static abstract class AesSecretValueBuilder<C extends AesSecretValue, B extends AesSecretValueBuilder<C, B>>
    extends EncryptedSecretValue.EncryptedSecretValueBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AesSecretValue.AesSecretValueBuilder(super=" + super.toString() + ")";
        }
    }
}

