/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.impl.LocalStore;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.store.ConnectionFileSystem;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.FileSystem;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.LaunchableStore;
import io.xpipe.core.store.StatefulDataStore;
import java.nio.charset.Charset;

public interface ShellStore
extends DataStore,
StatefulDataStore,
LaunchableStore,
FileSystemStore {
    public static ShellStore createLocal() {
        return new LocalStore();
    }

    public static boolean isLocal(ShellStore s) {
        return s instanceof LocalStore;
    }

    @Override
    default public FileSystem createFileSystem() {
        return new ConnectionFileSystem(this.control(), this);
    }

    @Override
    default public String prepareLaunchCommand(String displayName) throws Exception {
        return this.control().prepareTerminalOpen(displayName);
    }

    default public ShellControl control() {
        ShellControl pc = this.createBasicControl();
        pc.onInit(processControl -> {
            this.setState("type", processControl.getShellDialect());
            this.setState("os", processControl.getOsType());
            this.setState("charset", processControl.getCharset());
        });
        return pc;
    }

    default public ShellDialect getShellType() {
        return this.getState("type", ShellDialect.class, null);
    }

    default public OsType getOsType() {
        return this.getOrComputeState("os", OsType.class, () -> {
            OsType osType;
            block8: {
                ShellControl sc = this.control().start();
                try {
                    osType = sc.getOsType();
                    if (sc == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (sc != null) {
                            try {
                                sc.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                sc.close();
            }
            return osType;
        });
    }

    default public Charset getCharset() {
        return this.getState("charset", Charset.class, null);
    }

    public ShellControl createBasicControl();

    default public ShellDialect determineType() throws Exception {
        try (ShellControl pc = this.control().start();){
            ShellDialect shellDialect = pc.getShellDialect();
            return shellDialect;
        }
    }

    @Override
    default public void validate() throws Exception {
        ShellControl pc = this.control().start();
        if (pc != null) {
            pc.close();
        }
    }

    default public String queryMachineName() throws Exception {
        try (ShellControl pc = this.control().start();){
            OsType operatingSystem = pc.getOsType();
            String string = operatingSystem.determineOperatingSystemName(pc);
            return string;
        }
    }
}

