/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.xpipe.core.store.DataFlow;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface DataStore {
    default public boolean shouldPersist() {
        return true;
    }

    default public boolean shouldSave() {
        return true;
    }

    default public boolean isComplete() {
        try {
            this.checkComplete();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    default public DataFlow getFlow() {
        return DataFlow.INPUT_OUTPUT;
    }

    default public boolean canOpen() throws Exception {
        return true;
    }

    default public boolean isContentExclusivelyAccessible() {
        return false;
    }

    default public void validate() throws Exception {
    }

    default public void checkComplete() throws Exception {
    }

    default public boolean delete() {
        return false;
    }

    default public <DS extends DataStore> DS asNeeded() {
        return (DS)this;
    }

    default public Optional<String> determineDefaultName() {
        return Optional.empty();
    }

    default public Optional<Instant> determineLastModified() throws IOException {
        return Optional.empty();
    }
}

