/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.util.JacksonizedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class WriteMode
extends JacksonizedValue {
    public static final Replace REPLACE = new Replace();
    public static final Append APPEND = new Append();
    public static final Prepend PREPEND = new Prepend();
    private static final List<WriteMode> ALL = new ArrayList<WriteMode>();

    public static void init(ModuleLayer layer) {
        if (ALL.size() == 0) {
            ALL.addAll(ServiceLoader.load(layer, WriteMode.class).stream().map(p -> (WriteMode)p.get()).toList());
        }
    }

    public static WriteMode byId(String id) {
        return ALL.stream().filter(writeMode -> writeMode.getId().equalsIgnoreCase(id)).findFirst().orElseThrow();
    }

    public final String getId() {
        return this.getClass().getAnnotation(JsonTypeName.class).value();
    }

    @JsonTypeName(value="replace")
    public static final class Replace
    extends WriteMode {
    }

    @JsonTypeName(value="append")
    public static final class Append
    extends WriteMode {
    }

    @JsonTypeName(value="prepend")
    public static final class Prepend
    extends WriteMode {
    }
}

