/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import io.xpipe.core.impl.PreservingTextWriteConnection;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.TextReadConnection;
import io.xpipe.core.source.TextWriteConnection;
import io.xpipe.core.source.WriteMode;
import io.xpipe.core.store.DataStore;

public abstract class TextDataSource<DS extends DataStore>
extends DataSource<DS> {
    private static final int MAX_LINE_READ = 1000;

    @Override
    public DataSourceType getType() {
        return DataSourceType.TEXT;
    }

    @Override
    public final TextReadConnection openReadConnection() {
        if (!this.isComplete()) {
            throw new UnsupportedOperationException();
        }
        return this.newReadConnection();
    }

    @Override
    public final TextWriteConnection openWriteConnection(WriteMode mode) {
        TextWriteConnection con = this.newWriteConnection(mode);
        if (con == null) {
            throw new UnsupportedOperationException(mode.getId());
        }
        return con;
    }

    protected TextWriteConnection newWriteConnection(WriteMode mode) {
        if (mode.equals(WriteMode.PREPEND)) {
            return new PreservingTextWriteConnection(this, this.newWriteConnection(WriteMode.REPLACE), false);
        }
        if (mode.equals(WriteMode.APPEND)) {
            return new PreservingTextWriteConnection(this, this.newWriteConnection(WriteMode.REPLACE), true);
        }
        return null;
    }

    protected abstract TextReadConnection newReadConnection();

    protected TextDataSource(TextDataSourceBuilder<DS, ?, ?> b) {
        super(b);
    }

    public static abstract class TextDataSourceBuilder<DS extends DataStore, C extends TextDataSource<DS>, B extends TextDataSourceBuilder<DS, C, B>>
    extends DataSource.DataSourceBuilder<DS, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TextDataSource.TextDataSourceBuilder(super=" + super.toString() + ")";
        }
    }
}

