/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.impl.PreservingTableWriteConnection;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.TableMapping;
import io.xpipe.core.source.TableReadConnection;
import io.xpipe.core.source.TableWriteConnection;
import io.xpipe.core.source.WriteMode;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.ShellStore;
import io.xpipe.core.util.ProxyProvider;
import io.xpipe.core.util.SimpleProxyFunction;
import java.util.Optional;

public abstract class TableDataSource<DS extends DataStore>
extends DataSource<DS> {
    public Optional<TupleType> determineDataType() throws Exception {
        boolean canRead;
        TableReadConnection readConnection = this.newReadConnection();
        boolean bl = canRead = readConnection != null && readConnection.canRead();
        if (canRead) {
            try (TableReadConnection in = readConnection;){
                readConnection.init();
                Optional<TupleType> optional = Optional.ofNullable(readConnection.getDataType());
                return optional;
            }
        }
        return Optional.empty();
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.TABLE;
    }

    @Override
    public final TableReadConnection openReadConnection() throws Exception {
        if (!this.isComplete()) {
            return TableReadConnection.empty();
        }
        ShellStore proxy = ProxyProvider.get().getProxy(this);
        if (proxy != null) {
            return (TableReadConnection)ProxyProvider.get().createRemoteReadConnection(this, proxy);
        }
        return this.newReadConnection();
    }

    public final Optional<TableMapping> createMapping(TupleType inputType) {
        return Optional.ofNullable((TableMapping)new CreateMappingFunction(this, inputType).callAndGet());
    }

    @Override
    public final TableWriteConnection openWriteConnection(WriteMode mode) throws Exception {
        TableWriteConnection con = this.newWriteConnection(mode);
        if (con == null) {
            throw new UnsupportedOperationException(mode.getId());
        }
        ShellStore proxy = ProxyProvider.get().getProxy(this);
        if (proxy != null) {
            return (TableWriteConnection)ProxyProvider.get().createRemoteWriteConnection(this, mode, proxy);
        }
        return con;
    }

    protected TableWriteConnection newWriteConnection(WriteMode mode) {
        if (mode.equals(WriteMode.PREPEND)) {
            return new PreservingTableWriteConnection(this, this.newWriteConnection(WriteMode.REPLACE), false);
        }
        if (mode.equals(WriteMode.APPEND)) {
            return new PreservingTableWriteConnection(this, this.newWriteConnection(WriteMode.REPLACE), true);
        }
        return null;
    }

    protected TableReadConnection newReadConnection() {
        throw new UnsupportedOperationException();
    }

    protected TableDataSource(TableDataSourceBuilder<DS, ?, ?> b) {
        super(b);
    }

    private static class CreateMappingFunction
    extends SimpleProxyFunction<TableMapping> {
        private TableDataSource<?> source;
        private TupleType type;
        private TableMapping mapping;

        public CreateMappingFunction(TableDataSource<?> source, TupleType type) {
            this.source = source;
            this.type = type;
        }

        @Override
        public void callLocal() {
            try (TableWriteConnection w = this.source.openWriteConnection(WriteMode.REPLACE);){
                w.init();
                this.mapping = w.createMapping(this.type).orElse(null);
            }
        }

        public CreateMappingFunction() {
        }
    }

    public static abstract class TableDataSourceBuilder<DS extends DataStore, C extends TableDataSource<DS>, B extends TableDataSourceBuilder<DS, C, B>>
    extends DataSource.DataSourceBuilder<DS, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TableDataSource.TableDataSourceBuilder(super=" + super.toString() + ")";
        }
    }
}

