/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ProcessControl;
import io.xpipe.core.process.ProcessOutputException;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.util.FailableFunction;
import io.xpipe.core.util.SecretValue;
import io.xpipe.core.util.XPipeSystemId;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public interface ShellControl
extends ProcessControl {
    default public boolean isLocal() {
        return this.getSystemId().equals(XPipeSystemId.getLocal());
    }

    public UUID getSystemId();

    public Semaphore getCommandLock();

    public ShellControl onInit(Consumer<ShellControl> var1);

    public ShellControl onExit(Consumer<ShellControl> var1);

    public ShellControl withMessageFormatter(Function<String, String> var1);

    @Override
    public String prepareTerminalOpen(String var1) throws Exception;

    public String prepareIntermediateTerminalOpen(String var1, String var2) throws Exception;

    public String getSystemTemporaryDirectory();

    public String getSubTemporaryDirectory();

    public void checkRunning();

    default public CommandControl osascriptCommand(String script) {
        return this.command(String.format("osascript - \"$@\" <<EOF\n%s\nEOF\n", script));
    }

    default public byte[] executeSimpleRawBytesCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            byte[] byArray = c.readRawBytesOrThrow();
            return byArray;
        }
    }

    default public String executeSimpleStringCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            String string = c.readStdoutOrThrow();
            return string;
        }
    }

    default public boolean executeSimpleBooleanCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            boolean bl = c.discardAndCheckExit();
            return bl;
        }
    }

    default public void executeSimpleCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            c.discardOrThrow();
        }
    }

    default public void executeSimpleCommand(String command, String failMessage) throws Exception {
        try (CommandControl c = this.command(command).start();){
            c.discardOrThrow();
        }
        catch (ProcessOutputException out) {
            throw ProcessOutputException.withPrefix(failMessage, out);
        }
    }

    default public String executeSimpleStringCommand(ShellDialect type, String command) throws Exception {
        try (ShellControl sub = this.subShell(type).start();){
            String string = sub.executeSimpleStringCommand(command);
            return string;
        }
    }

    public void restart() throws Exception;

    public OsType getOsType();

    public boolean checkCanElevate() throws Exception;

    public ShellControl elevated(String var1, FailableFunction<ShellControl, Boolean, Exception> var2);

    public ShellControl elevationPassword(SecretValue var1);

    public ShellControl initWith(String var1);

    public ShellControl initWith(List<String> var1);

    public ShellControl startTimeout(int var1);

    public SecretValue getElevationPassword();

    default public ShellControl subShell(@NonNull ShellDialect type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.subShell(p -> type.getOpenCommand(), new TerminalOpenFunction(this){

            @Override
            public boolean changesEnvironment() {
                return false;
            }

            @Override
            public String prepare(ShellControl sc, String command) {
                return command;
            }
        }).elevationPassword(this.getElevationPassword());
    }

    default public ShellControl identicalSubShell() {
        return this.subShell(p -> p.getShellDialect().getOpenCommand(), new TerminalOpenFunction(this){

            @Override
            public boolean changesEnvironment() {
                return false;
            }

            @Override
            public String prepare(ShellControl sc, String command) {
                return command;
            }
        }).elevationPassword(this.getElevationPassword());
    }

    default public ShellControl subShell(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return this.subShell(processControl -> command, new TerminalOpenFunction(this){

            @Override
            public boolean changesEnvironment() {
                return false;
            }

            @Override
            public String prepare(ShellControl sc, String command) {
                return command;
            }
        });
    }

    default public ShellControl enforcedDialect(ShellDialect type) throws Exception {
        this.start();
        if (this.getShellDialect().equals(type)) {
            return this;
        }
        return this.subShell(type).start();
    }

    default public <T> T enforceDialect(@NonNull ShellDialect type, Function<ShellControl, T> sc) throws Exception {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (this.isRunning() && this.getShellDialect().equals(type)) {
            return sc.apply(this);
        }
        try (ShellControl sub = this.subShell(type).start();){
            T t = sc.apply(sub);
            return t;
        }
    }

    public ShellControl subShell(FailableFunction<ShellControl, String, Exception> var1, TerminalOpenFunction var2);

    public void executeLine(String var1) throws Exception;

    public void cd(String var1) throws Exception;

    @Override
    public ShellControl start() throws Exception;

    public CommandControl command(FailableFunction<ShellControl, String, Exception> var1);

    public CommandControl command(FailableFunction<ShellControl, String, Exception> var1, FailableFunction<ShellControl, String, Exception> var2);

    default public CommandControl command(String ... command) {
        String[] c = (String[])Arrays.stream(command).filter(s -> s != null).toArray(String[]::new);
        return this.command((ShellControl shellProcessControl) -> String.join((CharSequence)"\n", c));
    }

    default public CommandControl command(List<String> command) {
        return this.command((ShellControl shellProcessControl) -> ShellDialect.flatten(command));
    }

    public void exitAndWait() throws IOException;

    public static interface TerminalOpenFunction {
        public boolean changesEnvironment();

        public String prepare(ShellControl var1, String var2) throws Exception;
    }
}

