/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import java.util.Arrays;
import java.util.stream.Collectors;

public class ProcessOutputException
extends Exception {
    private final int exitCode;
    private final String output;

    public static ProcessOutputException withPrefix(String customPrefix, ProcessOutputException ex) {
        String messageSuffix = ex.getOutput() != null && !ex.getOutput().isBlank() ? ":\n" + ex.getOutput() : "";
        String message = customPrefix + messageSuffix;
        return new ProcessOutputException(message, ex.getExitCode(), ex.getOutput());
    }

    public static ProcessOutputException of(int exitCode, String ... messages) {
        String combinedError = Arrays.stream(messages).filter(s -> s != null && !s.isBlank()).map(s -> s.strip()).collect(Collectors.joining("\n\n")).replaceAll("\r\n", "\n");
        boolean hasMessage = !combinedError.isBlank();
        Object errorSuffix = hasMessage ? ":\n" + combinedError : "";
        String message = switch (exitCode) {
            case -3 -> "Process did not start up properly and had to be killed" + (String)errorSuffix;
            case -2 -> "Wait for process exit timed out" + (String)errorSuffix;
            default -> "Process returned exit code " + exitCode + (String)errorSuffix;
        };
        return new ProcessOutputException(message, exitCode, combinedError);
    }

    private ProcessOutputException(String message, int exitCode, String output) {
        super(message);
        this.exitCode = exitCode;
        this.output = output;
    }

    public boolean isTimeOut() {
        return this.exitCode == -2;
    }

    public boolean isKill() {
        return this.exitCode == -3;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getOutput() {
        return this.output;
    }
}

