/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.impl.FileNames;
import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.PropertiesFormatsParser;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialects;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public sealed interface OsType {
    public static final Windows WINDOWS = new Windows();
    public static final Linux LINUX = new Linux();
    public static final MacOs MACOS = new MacOs();

    public static OsType getLocal() {
        String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (osName.contains("mac") || osName.contains("darwin")) {
            return MACOS;
        }
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("nux")) {
            return LINUX;
        }
        throw new UnsupportedOperationException("Unknown operating system");
    }

    default public String getXPipeHomeDirectory(ShellControl pc) throws Exception {
        return FileNames.join(this.getHomeDirectory(pc), ".xpipe");
    }

    default public String getSystemIdFile(ShellControl pc) throws Exception {
        String home = this.getXPipeHomeDirectory(pc);
        if (home == null || home.isBlank()) {
            return null;
        }
        return FileNames.join(home, "system_id");
    }

    public List<String> determineInterestingPaths(ShellControl var1) throws Exception;

    public String getHomeDirectory(ShellControl var1) throws Exception;

    public String getFileSystemSeparator();

    public String getName();

    public String getTempDirectory(ShellControl var1) throws Exception;

    public Map<String, String> getProperties(ShellControl var1) throws Exception;

    public String determineOperatingSystemName(ShellControl var1) throws Exception;

    public static final class MacOs
    implements OsType {
        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getHomeDirectory(pc);
            return List.of(home, FileNames.join(home, "Downloads"), FileNames.join(home, "Documents"), FileNames.join(home, "Desktop"), "/Applications", "/Library", "/System", "/etc");
        }

        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("HOME"));
        }

        @Override
        public String getTempDirectory(ShellControl pc) throws Exception {
            String found = pc.executeSimpleStringCommand(pc.getShellDialect().getPrintVariableCommand("TMPDIR"));
            if (found.isBlank()) {
                return "/tmp";
            }
            return found;
        }

        @Override
        public String getFileSystemSeparator() {
            return "/";
        }

        @Override
        public String getName() {
            return "Mac";
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) throws Exception {
            try (CommandControl c = pc.subShell(ShellDialects.BASH).command("sw_vers").start();){
                String text = c.readStdoutOrThrow();
                Map<String, String> map = PropertiesFormatsParser.parse(text, ":");
                return map;
            }
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) throws Exception {
            Map<String, String> properties = this.getProperties(pc);
            String name = pc.executeSimpleStringCommand("awk '/SOFTWARE LICENSE AGREEMENT FOR macOS/' '/System/Library/CoreServices/Setup Assistant.app/Contents/Resources/en.lproj/OSXSoftwareLicense.rtf' | awk -F 'macOS ' '{print $NF}' | awk '{print substr($0, 0, length($0)-1)}'");
            return properties.get("ProductName") + " " + name + " " + properties.get("ProductVersion");
        }
    }

    public static final class Windows
    implements OsType {
        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getHomeDirectory(pc);
            return List.of(home, FileNames.join(home, "Documents"), FileNames.join(home, "Downloads"), FileNames.join(home, "Desktop"));
        }

        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("USERPROFILE"));
        }

        @Override
        public String getFileSystemSeparator() {
            return "\\";
        }

        @Override
        public String getName() {
            return "Windows";
        }

        @Override
        public String getTempDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("TEMP"));
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) throws Exception {
            try (CommandControl c = pc.command("systeminfo").start();){
                String text = c.readStdoutOrThrow();
                Map<String, String> map = PropertiesFormatsParser.parse(text, ":");
                return map;
            }
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) {
            try {
                return pc.executeSimpleStringCommand("wmic os get Caption").lines().skip(1L).collect(Collectors.joining()).trim() + " " + pc.executeSimpleStringCommand("wmic os get Version").lines().skip(1L).collect(Collectors.joining()).trim();
            }
            catch (Throwable t) {
                return "Windows ?";
            }
        }
    }

    public static final class Linux
    implements OsType {
        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getHomeDirectory(pc);
            return List.of(home, FileNames.join(home, "Downloads"), FileNames.join(home, "Documents"), "/etc", "/tmp", "/var");
        }

        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("HOME"));
        }

        @Override
        public String getFileSystemSeparator() {
            return "/";
        }

        @Override
        public String getTempDirectory(ShellControl pc) {
            return "/tmp/";
        }

        @Override
        public String getName() {
            return "Linux";
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) {
            return null;
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) throws Exception {
            String text;
            try (CommandControl c = pc.command("lsb_release -a").start();){
                text = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0) {
                    String string = PropertiesFormatsParser.parse(text, ":").getOrDefault("Description", null);
                    return string;
                }
            }
            c = pc.command("cat /etc/*release").start();
            try {
                text = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0) {
                    String string = PropertiesFormatsParser.parse(text, "=").getOrDefault("PRETTY_NAME", null);
                    return string;
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            String type = "Unknown";
            try (CommandControl c = pc.command("uname -o").start();){
                String text2 = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0) {
                    type = text2.strip();
                }
            }
            String version = "?";
            try (CommandControl c = pc.command("uname -r").start();){
                String text3 = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0) {
                    version = text3.strip();
                }
            }
            return type + " " + version;
        }
    }
}

