/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.charsetter.Charsetter;
import io.xpipe.core.process.ProcessControl;
import io.xpipe.core.process.ProcessOutputException;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.util.FailableFunction;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Function;

public interface CommandControl
extends ProcessControl {
    public static final int UNASSIGNED_EXIT_CODE = -1;
    public static final int EXIT_TIMEOUT_EXIT_CODE = -2;
    public static final int START_FAILED_EXIT_CODE = -3;

    public CommandControl withMessageFormatter(Function<String, String> var1);

    public CommandControl terminalExitMode(TerminalExitMode var1);

    public CommandControl doesNotObeyReturnValueConvention();

    @Override
    public CommandControl sensitive();

    public CommandControl complex();

    public CommandControl notComplex();

    public CommandControl withWorkingDirectory(String var1);

    default public void execute() throws Exception {
        try (CommandControl c = this.start();){
            c.discardOrThrow();
        }
    }

    default public boolean executeAndCheck() throws Exception {
        try (CommandControl c = this.start();){
            boolean bl = c.discardAndCheckExit();
            return bl;
        }
    }

    public ShellControl getParent();

    public InputStream startExternalStdout() throws Exception;

    public OutputStream startExternalStdin() throws Exception;

    public boolean waitFor();

    public CommandControl withCustomCharset(Charset var1);

    public int getExitCode();

    default public CommandControl elevated(String message) {
        return this.elevated(message, v -> true);
    }

    public CommandControl elevated(String var1, FailableFunction<ShellControl, Boolean, Exception> var2);

    @Override
    public CommandControl start() throws Exception;

    public CommandControl exitTimeout(Integer var1);

    public void withStdoutOrThrow(Charsetter.FailableConsumer<InputStreamReader, Exception> var1);

    public String readStdoutDiscardErr() throws Exception;

    public void discardOrThrow() throws Exception;

    public void accumulateStdout(Consumer<String> var1);

    public void accumulateStderr(Consumer<String> var1);

    public byte[] readRawBytesOrThrow() throws Exception;

    public String readStdoutOrThrow() throws Exception;

    default public boolean discardAndCheckExit() throws ProcessOutputException {
        try {
            this.discardOrThrow();
            return true;
        }
        catch (ProcessOutputException ex) {
            if (ex.isTimeOut()) {
                throw ex;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void discardOut();

    public void discardErr();

    public static enum TerminalExitMode {
        KEEP_OPEN,
        CLOSE;

    }
}

