/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

public class CommandBuilder {
    private final boolean noQuoting;
    private final StringBuilder builder = new StringBuilder();

    public static CommandBuilder of() {
        return new CommandBuilder(false);
    }

    public static CommandBuilder ofNoQuotes() {
        return new CommandBuilder(true);
    }

    private CommandBuilder(boolean noQuoting) {
        this.noQuoting = noQuoting;
    }

    public CommandBuilder add(String ... s) {
        for (String s1 : s) {
            this.add(s1);
        }
        return this;
    }

    public CommandBuilder addQuoted(String s) {
        if (!this.builder.isEmpty()) {
            this.builder.append(' ');
        }
        if (this.noQuoting) {
            throw new IllegalArgumentException("No quoting rule conflicts with spaces an argument");
        }
        this.builder.append("\"").append(s).append("\"");
        return this;
    }

    public CommandBuilder add(String s) {
        if (!this.builder.isEmpty()) {
            this.builder.append(' ');
        }
        if (((String)s).contains(" ") || ((String)s).contains("\t")) {
            if (this.noQuoting) {
                throw new IllegalArgumentException("No quoting rule conflicts with spaces an argument");
            }
            s = "\"" + (String)s + "\"";
        }
        this.builder.append((String)s);
        return this;
    }

    public String build() {
        return this.builder.toString();
    }
}

