/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import io.xpipe.core.data.node.DataStructureNodeAcceptor;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.data.typed.TypedDataStreamWriter;
import io.xpipe.core.impl.SimpleTableWriteConnection;
import io.xpipe.core.impl.StreamWriteConnection;
import io.xpipe.core.impl.XpbtSource;
import io.xpipe.core.source.TableMapping;
import io.xpipe.core.store.StreamDataStore;
import io.xpipe.core.util.JacksonMapper;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class XpbtWriteConnection
extends StreamWriteConnection
implements SimpleTableWriteConnection<XpbtSource> {
    private final XpbtSource source;
    private TupleType writtenDescriptor;

    public XpbtWriteConnection(XpbtSource source) {
        super((StreamDataStore)source.getStore(), null);
        this.source = source;
    }

    @Override
    public DataStructureNodeAcceptor<TupleNode> writeLinesAcceptor(TableMapping mapping) {
        return t -> {
            this.writeDescriptor((TupleNode)t);
            TypedDataStreamWriter.writeStructure(this.outputStream, t, this.writtenDescriptor);
            return true;
        };
    }

    private void writeDescriptor(TupleNode tupleNode) throws IOException {
        if (this.writtenDescriptor != null) {
            return;
        }
        this.writtenDescriptor = TupleType.tableType(tupleNode.getKeyNames());
        OutputStreamWriter writer = new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8);
        JsonFactory f = new JsonFactory();
        try (JsonGenerator g = f.createGenerator((Writer)writer).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());){
            JacksonMapper.newMapper().disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).writeValue(g, tupleNode.getKeyNames());
            writer.append("\n");
        }
        writer.flush();
    }

    @Override
    public XpbtSource getSource() {
        return this.source;
    }
}

