/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.charsetter.NewLine;
import io.xpipe.core.charsetter.StreamCharset;
import io.xpipe.core.store.DataFlow;
import io.xpipe.core.store.KnownFormatStreamDataStore;
import io.xpipe.core.store.StatefulDataStore;
import io.xpipe.core.util.JacksonizedValue;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;

@JsonTypeName(value="drain")
@JsonDeserialize(builder=SinkDrainStoreBuilderImpl.class)
public class SinkDrainStore
extends JacksonizedValue
implements KnownFormatStreamDataStore,
StatefulDataStore {
    private final StreamCharset charset;
    private final NewLine newLine;

    public State getState() {
        return this.getState("state", State.class, State.NONE_CONNECTED);
    }

    private void setState(State n) {
        this.setState("state", (Object)n);
    }

    public Pipe getOrOpenPipe() {
        return this.getOrComputeState("pipe", Pipe.class, () -> {
            try {
                return Pipe.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public DataFlow getFlow() {
        if (this.getState() == State.NONE_CONNECTED) {
            return DataFlow.INPUT_OR_OUTPUT;
        }
        if (this.getState() == State.PRODUCER_CONNECTED) {
            return DataFlow.INPUT;
        }
        if (this.getState() == State.CONSUMER_CONNECTED) {
            return DataFlow.OUTPUT;
        }
        return null;
    }

    private void waitForOpen() {
        while (this.getState() != State.OPEN) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Override
    public boolean shouldPersist() {
        return this.getState() != State.CLOSED;
    }

    @Override
    public boolean shouldSave() {
        return false;
    }

    @Override
    public boolean canOpen() {
        return this.getState() == State.PRODUCER_CONNECTED;
    }

    @Override
    public InputStream openInput() {
        this.checkState(false);
        if (this.getState() == State.PRODUCER_CONNECTED) {
            this.setState(State.OPEN);
        }
        if (this.getState() == State.NONE_CONNECTED) {
            this.setState(State.CONSUMER_CONNECTED);
        }
        try {
            return new FilterInputStream(Channels.newInputStream(this.getOrOpenPipe().source())){

                @Override
                public void close() throws IOException {
                    super.close();
                    SinkDrainStore.this.setState(State.CLOSED);
                }
            };
        }
        catch (Exception ex) {
            this.setState(State.CLOSED);
            throw ex;
        }
    }

    @Override
    public OutputStream openOutput() {
        this.checkState(true);
        if (this.getState() == State.CONSUMER_CONNECTED) {
            this.setState(State.OPEN);
        }
        if (this.getState() == State.NONE_CONNECTED) {
            this.setState(State.PRODUCER_CONNECTED);
        }
        try {
            return new FilterOutputStream(Channels.newOutputStream(this.getOrOpenPipe().sink())){

                @Override
                public void close() throws IOException {
                    super.close();
                    SinkDrainStore.this.setState(State.CLOSED);
                }
            };
        }
        catch (Exception ex) {
            this.setState(State.CLOSED);
            throw ex;
        }
    }

    private void checkState(boolean isProducer) {
        if (this.getState() == State.CLOSED) {
            throw new IllegalStateException("Drain has already been closed");
        }
        if (this.getState() == State.OPEN) {
            throw new IllegalStateException("Drain is already open");
        }
        if (this.getState() == State.PRODUCER_CONNECTED && isProducer) {
            throw new IllegalStateException("Producer is already connected");
        }
        if (this.getState() == State.CONSUMER_CONNECTED && !isProducer) {
            throw new IllegalStateException("Consumer is already connected");
        }
    }

    protected SinkDrainStore(SinkDrainStoreBuilder<?, ?> b) {
        super(b);
        this.charset = b.charset;
        this.newLine = b.newLine;
    }

    public static SinkDrainStoreBuilder<?, ?> builder() {
        return new SinkDrainStoreBuilderImpl();
    }

    @Override
    public StreamCharset getCharset() {
        return this.charset;
    }

    @Override
    public NewLine getNewLine() {
        return this.newLine;
    }

    public static enum State {
        NONE_CONNECTED,
        PRODUCER_CONNECTED,
        CONSUMER_CONNECTED,
        OPEN,
        CLOSED;

    }

    public static abstract class SinkDrainStoreBuilder<C extends SinkDrainStore, B extends SinkDrainStoreBuilder<C, B>>
    extends JacksonizedValue.JacksonizedValueBuilder<C, B> {
        private StreamCharset charset;
        private NewLine newLine;

        public B charset(StreamCharset charset) {
            this.charset = charset;
            return (B)this.self();
        }

        public B newLine(NewLine newLine) {
            this.newLine = newLine;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SinkDrainStore.SinkDrainStoreBuilder(super=" + super.toString() + ", charset=" + String.valueOf(this.charset) + ", newLine=" + String.valueOf((Object)this.newLine) + ")";
        }
    }

    @JsonTypeName(value="drain")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SinkDrainStoreBuilderImpl
    extends SinkDrainStoreBuilder<SinkDrainStore, SinkDrainStoreBuilderImpl> {
        private SinkDrainStoreBuilderImpl() {
        }

        @Override
        protected SinkDrainStoreBuilderImpl self() {
            return this;
        }

        @Override
        public SinkDrainStore build() {
            return new SinkDrainStore(this);
        }
    }
}

