/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import io.xpipe.core.impl.FileStore;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceConnection;
import io.xpipe.core.source.DataSourceReadConnection;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.WriteMode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class PreservingWriteConnection
implements DataSourceConnection {
    protected final DataSourceConnection connection;
    private final DataSourceType type;
    private final DataSource<?> source;
    private final boolean append;

    public PreservingWriteConnection(DataSourceType type, DataSource<?> source, boolean append, DataSourceConnection connection) {
        this.type = type;
        this.source = source;
        this.append = append;
        this.connection = connection;
    }

    @Override
    public void init() throws Exception {
        DataSourceReadConnection in;
        Path temp = Files.createTempFile(null, null, new FileAttribute[0]);
        FileStore nativeStore = FileStore.local(temp);
        DataSource<?> nativeSource = DataSource.createInternalDataSource(this.type, nativeStore);
        if (this.source.getStore().canOpen()) {
            in = this.source.openReadConnection();
            try (DataSourceConnection out = nativeSource.openWriteConnection(WriteMode.REPLACE);){
                in.init();
                out.init();
                in.forward(out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        this.connection.init();
        if (this.source.getStore().canOpen()) {
            in = nativeSource.openReadConnection();
            try {
                in.init();
                in.forward(this.connection);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }
}

