/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import io.xpipe.core.charsetter.StreamCharset;
import io.xpipe.core.data.node.DataStructureNodeAcceptor;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.impl.StreamReadConnection;
import io.xpipe.core.source.TableReadConnection;
import io.xpipe.core.store.StreamDataStore;
import java.util.concurrent.atomic.AtomicReference;

public abstract class PeekTableStreamReadConnection
extends StreamReadConnection
implements TableReadConnection {
    private TupleNode first;
    private TupleType type;

    public PeekTableStreamReadConnection(StreamDataStore store, StreamCharset charset) {
        super(store, charset);
    }

    @Override
    public void init() throws Exception {
        super.init();
        AtomicReference read = new AtomicReference();
        this.withRowsInternal(node -> {
            read.set(node);
            return false;
        });
        if (read.get() == null) {
            return;
        }
        this.first = ((TupleNode)read.get()).asTuple();
        this.type = this.convertType(this.first);
    }

    protected TupleType convertType(TupleNode n) {
        return n.determineDataType().asTuple();
    }

    @Override
    public void close() throws Exception {
        if (this.inputStream == null) {
            throw new IllegalStateException("Not initialized");
        }
        this.inputStream.close();
    }

    @Override
    public TupleType getDataType() {
        return this.type;
    }

    @Override
    public final void withRows(DataStructureNodeAcceptor<TupleNode> lineAcceptor) throws Exception {
        if (this.first != null) {
            lineAcceptor.accept(this.first);
            this.first = null;
        }
        this.withRowsInternal(lineAcceptor);
    }

    protected abstract void withRowsInternal(DataStructureNodeAcceptor<TupleNode> var1) throws Exception;
}

