/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.impl;

import io.xpipe.core.data.node.DataStructureNodeAcceptor;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.source.TableReadConnection;
import java.util.OptionalInt;

public class LimitTableReadConnection
implements TableReadConnection {
    private final TableReadConnection connection;
    private final int maxCount;
    private int count = 0;

    public LimitTableReadConnection(TableReadConnection connection, int maxCount) {
        this.connection = connection;
        this.maxCount = maxCount;
    }

    @Override
    public void init() throws Exception {
        this.connection.init();
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public TupleType getDataType() {
        return this.connection.getDataType();
    }

    @Override
    public OptionalInt getRowCount() throws Exception {
        return this.connection.getRowCount();
    }

    @Override
    public void withRows(DataStructureNodeAcceptor<TupleNode> lineAcceptor) throws Exception {
        this.connection.withRows(node -> {
            if (this.count == this.maxCount) {
                return false;
            }
            ++this.count;
            return lineAcceptor.accept((TupleNode)node);
        });
    }

    @Override
    public boolean canRead() throws Exception {
        return this.connection.canRead();
    }
}

