/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.dialog;

import io.xpipe.core.charsetter.Charsetter;
import io.xpipe.core.dialog.BusyElement;
import io.xpipe.core.dialog.ChoiceElement;
import io.xpipe.core.dialog.DialogElement;
import io.xpipe.core.dialog.HeaderElement;
import io.xpipe.core.dialog.QueryConverter;
import io.xpipe.core.dialog.QueryElement;
import io.xpipe.core.util.SecretValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Dialog {
    private final List<Charsetter.FailableConsumer<?, Exception>> completion = new ArrayList();
    protected Object eval;
    private Supplier<?> evaluation;

    public static Dialog empty() {
        return new Dialog(){

            @Override
            public DialogElement start() throws Exception {
                this.complete();
                return null;
            }

            @Override
            protected DialogElement next(String answer) throws Exception {
                this.complete();
                return null;
            }
        };
    }

    public static Choice choice(String description, List<io.xpipe.core.dialog.Choice> elements, boolean required, boolean quiet, int selected) {
        Choice c = new Choice(description, elements, required, quiet, selected);
        c.evaluateTo(c::getSelected);
        return c;
    }

    @SafeVarargs
    public static <T> Choice choice(String description, Function<T, String> toString, boolean required, boolean quiet, T def, T ... vals) {
        List<io.xpipe.core.dialog.Choice> elements = Arrays.stream(vals).map((? super T v) -> new io.xpipe.core.dialog.Choice(null, (String)toString.apply(v))).toList();
        int index = Arrays.asList(vals).indexOf(def);
        if (def != null && index == -1) {
            throw new IllegalArgumentException("Default value " + String.valueOf(def) + " is not in possible values");
        }
        Choice c = Dialog.choice(description, elements, required, quiet, index);
        c.evaluateTo(() -> {
            if (c.getSelected() == -1) {
                return null;
            }
            return vals[c.getSelected()];
        });
        return c;
    }

    public static <T> Query query(String description, boolean newLine, boolean required, boolean quiet, T value, QueryConverter<T> converter) {
        Query q = new Query(description, newLine, required, quiet, value, converter, false);
        q.evaluateTo(q::getConvertedValue);
        return q;
    }

    public static Query querySecret(String description, boolean newLine, boolean required, SecretValue value) {
        Query q = new Query(description, newLine, required, false, value, QueryConverter.SECRET, true);
        q.evaluateTo(q::getConvertedValue);
        return q;
    }

    public static Dialog chain(final Dialog ... ds) {
        return new Dialog(){
            private int current = 0;

            @Override
            public DialogElement start() throws Exception {
                this.current = 0;
                this.eval = null;
                do {
                    DialogElement start;
                    if ((start = ds[this.current].start()) == null) continue;
                    return start;
                } while (++this.current < ds.length);
                this.current = ds.length - 1;
                return null;
            }

            @Override
            protected DialogElement next(String answer) throws Exception {
                DialogElement currentElement = ds[this.current].receive(answer);
                if (currentElement == null) {
                    DialogElement next = null;
                    while (this.current < ds.length - 1 && (next = ds[++this.current].start()) == null) {
                    }
                    return next;
                }
                return currentElement;
            }
        }.evaluateTo(ds[ds.length - 1]);
    }

    public static <T> Dialog repeatIf(final Dialog d, final Predicate<T> shouldRepeat) {
        return new Dialog(){

            @Override
            public DialogElement start() throws Exception {
                this.eval = null;
                return d.start();
            }

            @Override
            protected DialogElement next(String answer) throws Exception {
                DialogElement next = d.receive(answer);
                if (next == null && shouldRepeat.test(d.getResult())) {
                    return d.start();
                }
                return next;
            }
        }.evaluateTo(d).onCompletion(d.completion);
    }

    public static Dialog header(String msg) {
        return Dialog.of(new HeaderElement(msg)).evaluateTo(() -> msg);
    }

    public static Dialog header(final Supplier<String> msg) {
        final String[] msgEval = new String[]{null};
        return new Dialog(){

            @Override
            public DialogElement start() {
                msgEval[0] = (String)msg.get();
                return new HeaderElement(msgEval[0]);
            }

            @Override
            protected DialogElement next(String answer) {
                return null;
            }
        }.evaluateTo(() -> msgEval[0]);
    }

    public static Dialog busy() {
        return Dialog.of(new BusyElement());
    }

    public static Dialog lazy(final FailableSupplier<Dialog> d) {
        return new Dialog(){
            Dialog dialog;

            @Override
            public DialogElement start() throws Exception {
                this.eval = null;
                this.dialog = (Dialog)d.get();
                DialogElement start = this.dialog.start();
                this.evaluateTo(this.dialog);
                if (start == null) {
                    this.complete();
                }
                return start;
            }

            @Override
            protected DialogElement next(String answer) throws Exception {
                return this.dialog.receive(answer);
            }
        };
    }

    private static Dialog of(final DialogElement e) {
        return new Dialog(){

            @Override
            public DialogElement start() {
                this.eval = null;
                return e;
            }

            @Override
            protected DialogElement next(String answer) {
                if (e.apply(answer)) {
                    return null;
                }
                return e;
            }
        };
    }

    public static Dialog skipIf(final Dialog d, final Supplier<Boolean> check) {
        return new Dialog(){
            private Dialog active;

            @Override
            public DialogElement start() throws Exception {
                Dialog dialog = this.active = (Boolean)check.get() != false ? null : d;
                if (this.active == null) {
                    this.complete();
                }
                return this.active != null ? this.active.start() : null;
            }

            @Override
            protected DialogElement next(String answer) throws Exception {
                return this.active != null ? this.active.receive(answer) : null;
            }
        }.evaluateTo(d).onCompletion(d.completion);
    }

    public static <T> Dialog retryIf(final Dialog d, final Function<T, String> msg) {
        return new Dialog(){
            private boolean retry;

            @Override
            public DialogElement start() throws Exception {
                this.eval = null;
                return d.start();
            }

            @Override
            protected DialogElement next(String answer) throws Exception {
                String s;
                if (this.retry) {
                    this.retry = false;
                    return d.start();
                }
                DialogElement next = d.receive(answer);
                if (next == null && (s = (String)msg.apply(d.getResult())) != null) {
                    this.retry = true;
                    return new HeaderElement(s);
                }
                return next;
            }
        }.evaluateTo(d.evaluation).onCompletion(d.completion);
    }

    public static Dialog fork(String description, List<io.xpipe.core.dialog.Choice> elements, boolean required, int selected, final Function<Integer, Dialog> c) {
        final ChoiceElement choice = new ChoiceElement(description, elements, required, false, selected);
        return new Dialog(){
            private Dialog choiceMade;
            {
                this.evaluateTo(() -> this.choiceMade);
            }

            @Override
            public DialogElement start() {
                this.choiceMade = null;
                this.eval = null;
                return choice;
            }

            @Override
            protected DialogElement next(String answer) throws Exception {
                if (this.choiceMade != null) {
                    DialogElement r = this.choiceMade.receive(answer);
                    return r;
                }
                if (choice.apply(answer)) {
                    this.choiceMade = (Dialog)c.apply(choice.getSelected());
                    return this.choiceMade != null ? this.choiceMade.start() : null;
                }
                return choice;
            }
        };
    }

    public void clearCompletion() {
        this.completion.clear();
    }

    public abstract DialogElement start() throws Exception;

    public Dialog evaluateTo(Dialog d) {
        this.evaluation = () -> d.evaluation != null ? d.evaluation.get() : null;
        return this;
    }

    public Dialog evaluateTo(Supplier<?> s) {
        this.evaluation = s;
        return this;
    }

    public <T> Dialog map(Function<T, ?> s) {
        Supplier<?> oldEval = this.evaluation;
        this.evaluation = () -> s.apply(oldEval.get());
        return this;
    }

    public Dialog onCompletion(Charsetter.FailableConsumer<?, Exception> s) {
        this.completion.add(s);
        return this;
    }

    public Dialog onCompletion(Runnable r) {
        this.completion.add(v -> r.run());
        return this;
    }

    public Dialog onCompletion(List<Charsetter.FailableConsumer<?, Exception>> s) {
        this.completion.addAll(s);
        return this;
    }

    public <T> T getResult() {
        return (T)this.eval;
    }

    public <T> void complete() throws Exception {
        if (this.evaluation != null) {
            this.eval = this.evaluation.get();
            Iterator<Charsetter.FailableConsumer<?, Exception>> iterator = this.completion.iterator();
            while (iterator.hasNext()) {
                Charsetter.FailableConsumer<?, Exception> c;
                Charsetter.FailableConsumer<?, Exception> ct = c = iterator.next();
                ct.accept(this.eval);
            }
        }
    }

    public final DialogElement receive(String answer) throws Exception {
        DialogElement next = this.next(answer);
        if (next == null) {
            this.complete();
        }
        return next;
    }

    protected abstract DialogElement next(String var1) throws Exception;

    public static class Choice
    extends Dialog {
        private final ChoiceElement element;

        private Choice(String description, List<io.xpipe.core.dialog.Choice> elements, boolean required, boolean quiet, int selected) {
            this.element = new ChoiceElement(description, elements, required, quiet, selected);
        }

        @Override
        public DialogElement start() {
            return this.element;
        }

        @Override
        protected DialogElement next(String answer) {
            if (this.element.apply(answer)) {
                return null;
            }
            return this.element;
        }

        private int getSelected() {
            return this.element.getSelected();
        }
    }

    public static class Query
    extends Dialog {
        private final QueryElement element;

        private <T> Query(String description, boolean newLine, boolean required, boolean quiet, T value, QueryConverter<T> converter, boolean hidden) {
            this.element = new QueryElement(description, newLine, required, quiet, value, converter, hidden);
        }

        @Override
        public DialogElement start() {
            return this.element;
        }

        @Override
        protected DialogElement next(String answer) {
            if (this.element.requiresExplicitUserInput() && (answer == null || answer.trim().length() == 0)) {
                return this.element;
            }
            if (this.element.apply(answer)) {
                return null;
            }
            return this.element;
        }

        private <T> T getConvertedValue() {
            return this.element.getConvertedValue();
        }
    }

    public static interface FailableSupplier<T> {
        public T get() throws Exception;
    }
}

