/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.type;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.DataTypeVisitor;
import java.util.Optional;

@JsonTypeName(value="value")
public final class ValueType
extends DataType {
    public static ValueType of() {
        return new ValueType();
    }

    @Override
    public String getName() {
        return "value";
    }

    @Override
    public Optional<DataStructureNode> convert(DataStructureNode node) {
        if (this.matches(node)) {
            return Optional.of(node);
        }
        if (node.size() == 1) {
            DataStructureNode n = node.at(0);
            return this.convert(n);
        }
        return Optional.empty();
    }

    @Override
    public boolean matches(DataStructureNode node) {
        return node.isValue();
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public void visit(DataTypeVisitor visitor) {
        visitor.onValue(this);
    }

    public String toString() {
        return "ValueType()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueType)) {
            return false;
        }
        ValueType other = (ValueType)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueType;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private ValueType() {
    }
}

