/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.DataTypeVisitor;
import io.xpipe.core.data.type.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonTypeName(value="tuple")
public final class TupleType
extends DataType {
    private final List<String> names;
    private final List<DataType> types;

    public static TupleType tableType(List<String> names) {
        return TupleType.of(names, Collections.nCopies(names.size(), WildcardType.of()));
    }

    public static TupleType empty() {
        return new TupleType(List.of(), List.of());
    }

    @JsonCreator
    public static TupleType of(List<String> names, List<DataType> types) {
        return new TupleType(names, types);
    }

    public static TupleType of(List<DataType> types) {
        return new TupleType(Collections.nCopies(types.size(), null), types);
    }

    public boolean hasAllNames() {
        return this.names.stream().allMatch(Objects::nonNull);
    }

    public TupleType sub(List<String> subNames) {
        if (!this.hasAllNames()) {
            throw new UnsupportedOperationException();
        }
        return new TupleType(subNames, subNames.stream().map(s -> this.types.get(this.getNames().indexOf(s))).toList());
    }

    @Override
    public String getName() {
        return "tuple";
    }

    @Override
    public Optional<DataStructureNode> convert(DataStructureNode node) {
        if (this.matches(node)) {
            return Optional.of(node);
        }
        if (node.isValue() && this.types.size() == 1) {
            return this.types.get(0).convert(node);
        }
        if (node.size() != this.types.size()) {
            return Optional.empty();
        }
        ArrayList<DataStructureNode> nodes = new ArrayList<DataStructureNode>(node.size());
        for (int i = 0; i < node.size(); ++i) {
            Optional<DataStructureNode> converted = this.types.get(i).convert(node.at(i));
            if (converted.isEmpty()) {
                return Optional.empty();
            }
            nodes.add(converted.get());
        }
        return Optional.of(TupleNode.of(this.names, nodes));
    }

    @Override
    public boolean matches(DataStructureNode node) {
        if (!node.isTuple()) {
            return false;
        }
        TupleNode t = node.asTuple();
        if (t.size() != this.getSize()) {
            return false;
        }
        int counter = 0;
        for (DataStructureNode.KeyValue kv : t.getKeyValuePairs()) {
            if (!Objects.equals(kv.key(), this.names.get(counter))) {
                return false;
            }
            if (!this.types.get(counter).matches(kv.value())) {
                return false;
            }
            ++counter;
        }
        return true;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public void visit(DataTypeVisitor visitor) {
        visitor.onTuple(this);
    }

    public int getSize() {
        return this.types.size();
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<DataType> getTypes() {
        return this.types;
    }

    public String toString() {
        return "TupleType(names=" + String.valueOf(this.getNames()) + ", types=" + String.valueOf(this.getTypes()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TupleType)) {
            return false;
        }
        TupleType other = (TupleType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<DataType> this$types = this.getTypes();
        List<DataType> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TupleType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<DataType> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }

    private TupleType(List<String> names, List<DataType> types) {
        this.names = names;
        this.types = types;
    }
}

