/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.type;

import io.xpipe.core.data.node.DataStructureNodePointer;
import io.xpipe.core.data.type.ArrayType;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.DataTypeVisitor;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.data.type.ValueType;
import io.xpipe.core.data.type.WildcardType;
import java.util.Iterator;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class DataTypeVisitors {
    public static DataTypeVisitor flatten(final Consumer<DataType> typeConsumer) {
        return new DataTypeVisitor(){

            @Override
            public void onValue(ValueType type) {
                typeConsumer.accept(type);
            }

            @Override
            public void onTuple(TupleType type) {
                typeConsumer.accept(type);
                type.getTypes().forEach(t -> t.visit(this));
            }

            @Override
            public void onArray(ArrayType type) {
                typeConsumer.accept(type);
                typeConsumer.accept(type.getSharedType());
            }

            @Override
            public void onWildcard(WildcardType type) {
                typeConsumer.accept(type);
            }
        };
    }

    public static DataTypeVisitor table(final Consumer<String> newTuple, final Runnable endTuple, final BiConsumer<String, DataStructureNodePointer> newValue) {
        return new DataTypeVisitor(){
            private final Stack<TupleType> tuples = new Stack();
            private final Stack<Integer> keyIndices = new Stack();

            private boolean isOnTopLevel() {
                return this.tuples.size() <= 1;
            }

            private void onAnyValue() {
                DataStructureNodePointer.Builder pointer = DataStructureNodePointer.builder();
                Iterator iterator = this.keyIndices.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    pointer.index(index);
                }
                DataStructureNodePointer p = pointer.build();
                newValue.accept(this.tuples.peek().getNames().get(this.keyIndices.peek()), p);
                this.moveIndex();
            }

            private void moveIndex() {
                Integer index;
                Integer n = index = this.keyIndices.pop();
                index = index + 1;
                this.keyIndices.push(index);
            }

            @Override
            public void onValue(ValueType type) {
                this.onAnyValue();
            }

            @Override
            public void onWildcard(WildcardType type) {
                this.onAnyValue();
            }

            @Override
            public void onTuple(TupleType tuple) {
                if (!this.isOnTopLevel()) {
                    this.moveIndex();
                }
                this.tuples.push(tuple);
                this.keyIndices.push(0);
                if (!this.isOnTopLevel()) {
                    newTuple.accept(this.tuples.peek().getNames().get(this.keyIndices.peek()));
                }
                tuple.getTypes().forEach(t -> t.visit(this));
                endTuple.run();
                this.tuples.pop();
                this.keyIndices.pop();
            }

            @Override
            public void onArray(ArrayType type) {
                this.onAnyValue();
            }
        };
    }
}

