/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.type;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.type.ArrayType;
import io.xpipe.core.data.type.DataTypeVisitor;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.data.type.ValueType;
import io.xpipe.core.data.type.WildcardType;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class DataType {
    public abstract String getName();

    public abstract Optional<DataStructureNode> convert(DataStructureNode var1);

    public abstract boolean matches(DataStructureNode var1);

    public boolean isTuple() {
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public final WildcardType asWildcard() {
        if (!this.isWildcard()) {
            throw new UnsupportedOperationException(this.getName() + " is not a wildcard type");
        }
        return (WildcardType)this;
    }

    public final ValueType asValue() {
        if (!this.isValue()) {
            throw new UnsupportedOperationException(this.getName() + " is not a value type");
        }
        return (ValueType)this;
    }

    public final TupleType asTuple() {
        if (!this.isTuple()) {
            throw new UnsupportedOperationException(this.getName() + " is not a tuple type");
        }
        return (TupleType)this;
    }

    public final ArrayType asArray() {
        if (!this.isArray()) {
            throw new UnsupportedOperationException(this.getName() + " is not an array type");
        }
        return (ArrayType)this;
    }

    public abstract void visit(DataTypeVisitor var1);
}

