/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.type;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.DataTypeVisitor;
import io.xpipe.core.data.type.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@JsonTypeName(value="array")
public final class ArrayType
extends DataType {
    private final DataType sharedType;

    public static ArrayType of(DataType type) {
        return new ArrayType(type);
    }

    public static ArrayType ofSharedType(List<DataType> types) {
        if (types.size() == 0) {
            return new ArrayType(WildcardType.of());
        }
        DataType first = types.get(0);
        boolean eq = types.stream().allMatch(d -> d.equals(first));
        return new ArrayType(eq ? first : WildcardType.of());
    }

    @Override
    public String getName() {
        return "array";
    }

    @Override
    public Optional<DataStructureNode> convert(DataStructureNode node) {
        if (this.matches(node)) {
            return Optional.of(node);
        }
        if (node.isValue()) {
            return Optional.of(ArrayNode.of(node));
        }
        ArrayList<DataStructureNode> nodes = new ArrayList<DataStructureNode>(node.size());
        for (int i = 0; i < node.size(); ++i) {
            Optional<DataStructureNode> converted = this.sharedType.convert(node.at(i));
            if (converted.isEmpty()) {
                return Optional.empty();
            }
            nodes.add(converted.get());
        }
        return Optional.of(ArrayNode.of(nodes));
    }

    @Override
    public boolean matches(DataStructureNode node) {
        if (!node.isArray()) {
            return false;
        }
        ArrayNode a = node.asArray();
        for (DataStructureNode n : a) {
            if (this.sharedType.matches(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public void visit(DataTypeVisitor visitor) {
        visitor.onArray(this);
    }

    public DataType getSharedType() {
        return this.sharedType;
    }

    public String toString() {
        return "ArrayType(sharedType=" + String.valueOf(this.getSharedType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataType this$sharedType = this.getSharedType();
        DataType other$sharedType = other.getSharedType();
        return !(this$sharedType == null ? other$sharedType != null : !this$sharedType.equals(other$sharedType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArrayType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataType $sharedType = this.getSharedType();
        result = result * 59 + ($sharedType == null ? 43 : $sharedType.hashCode());
        return result;
    }

    private ArrayType(DataType sharedType) {
        this.sharedType = sharedType;
    }
}

