/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.node;

import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.SimpleValueNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.ValueType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Currency;
import java.util.Objects;

public abstract class ValueNode
extends DataStructureNode {
    protected ValueNode() {
    }

    public static ValueNode nullValue() {
        return new SimpleValueNode(new byte[0]).tag(IS_NULL).asValue();
    }

    public static ValueNode of(byte[] data) {
        if (data == null) {
            return ValueNode.nullValue();
        }
        return new SimpleValueNode(data);
    }

    public static ValueNode ofDate(String raw, Instant instant) {
        ValueNode created = ValueNode.of(raw);
        created.tag(IS_DATE);
        created.tag(DATE_VALUE, instant.toString());
        return created;
    }

    public static ValueNode ofDecimal(String raw, double decimal) {
        return ValueNode.ofDecimal(raw, String.valueOf(decimal));
    }

    public static ValueNode ofDecimal(String raw, String decimal) {
        ValueNode created = ValueNode.of(raw);
        created.tag(IS_DECIMAL);
        created.tag(DECIMAL_VALUE, decimal);
        return created;
    }

    public static ValueNode ofInteger(String raw, long integer) {
        return ValueNode.ofInteger(raw, String.valueOf(integer));
    }

    public static ValueNode ofInteger(String raw, String integer) {
        ValueNode created = ValueNode.of(raw);
        created.tag(IS_INTEGER);
        created.tag(INTEGER_VALUE, integer);
        return created;
    }

    public static ValueNode ofCurrency(String raw, String decimal, Currency currency) {
        ValueNode created = ValueNode.ofDecimal(raw, decimal);
        created.tag(IS_CURRENCY);
        created.tag(CURRENCY_CODE, currency.getCurrencyCode());
        return created;
    }

    public static ValueNode ofBytes(byte[] data) {
        ValueNode created = ValueNode.of(data);
        if (data != null) {
            created.tag(IS_BINARY);
        }
        return created;
    }

    public static ValueNode ofText(String text) {
        ValueNode created = ValueNode.of(text);
        if (text != null) {
            created.tag(IS_TEXT);
        }
        return created;
    }

    public static ValueNode ofInteger(int integer) {
        ValueNode created = ValueNode.of(integer);
        created.tag(IS_INTEGER);
        created.tag(INTEGER_VALUE, integer);
        return created;
    }

    public static ValueNode ofInteger(BigInteger integer) {
        ValueNode created = ValueNode.of(integer);
        if (integer != null) {
            created.tag(IS_INTEGER);
            created.tag(INTEGER_VALUE, integer);
        }
        return created;
    }

    public static ValueNode ofDecimal(double decimal) {
        ValueNode created = ValueNode.of(decimal);
        created.tag(IS_DECIMAL);
        created.tag(DECIMAL_VALUE, decimal);
        return created;
    }

    public static ValueNode ofDecimal(BigDecimal decimal) {
        ValueNode created = ValueNode.of(decimal);
        if (decimal != null) {
            created.tag(IS_DECIMAL);
            created.tag(DECIMAL_VALUE, decimal);
        }
        return created;
    }

    public static ValueNode ofBoolean(Boolean bool) {
        ValueNode created = ValueNode.of(bool);
        if (bool != null) {
            created.tag(IS_BOOLEAN);
            created.tag(bool != false ? BOOLEAN_TRUE : BOOLEAN_FALSE);
        }
        return created;
    }

    public static ValueNode of(Object o) {
        if (o == null) {
            return ValueNode.nullValue();
        }
        return ValueNode.of(o.toString().getBytes(StandardCharsets.UTF_8));
    }

    public boolean equals(Object o) {
        boolean toReturn;
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueNode)) {
            return false;
        }
        ValueNode that = (ValueNode)o;
        boolean bl = toReturn = Arrays.equals(this.getRawData(), that.getRawData()) && Objects.equals(this.getMetaAttributes(), that.getMetaAttributes());
        if (!toReturn) {
            return false;
        }
        return toReturn;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData()) + Objects.hash(this.getMetaAttributes());
    }

    @Override
    public final int asInt() {
        return Integer.parseInt(this.asString());
    }

    @Override
    public final boolean isValue() {
        return true;
    }

    @Override
    protected final String getName() {
        return "value node";
    }

    @Override
    public final DataType determineDataType() {
        return ValueType.of();
    }

    public abstract byte[] getRawData();
}

