/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.node;

import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.TupleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SimpleTupleNode
extends TupleNode {
    private final List<String> names;
    private final List<DataStructureNode> nodes;

    public SimpleTupleNode(List<String> names, List<DataStructureNode> nodes) {
        this.names = names;
        this.nodes = nodes;
    }

    @Override
    public DataStructureNode set(int index, DataStructureNode node) {
        this.nodes.set(index, node);
        return this;
    }

    @Override
    public DataType determineDataType() {
        List<DataType> subtypes = this.nodes.stream().map(DataStructureNode::determineDataType).toList();
        return this.names != null ? TupleType.of(this.names, subtypes) : TupleType.of(subtypes);
    }

    @Override
    protected String getName() {
        return "tuple node";
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public DataStructureNode at(int index) {
        return this.nodes.get(index);
    }

    @Override
    public DataStructureNode forKey(String name) {
        int index;
        int n = index = this.names != null ? this.names.indexOf(name) : -1;
        if (index == -1) {
            throw new IllegalArgumentException("Key " + name + " not found");
        }
        return this.nodes.get(index);
    }

    @Override
    public Optional<DataStructureNode> forKeyIfPresent(String name) {
        if (this.names == null || !this.names.contains(name)) {
            return Optional.empty();
        }
        return Optional.of(this.nodes.get(this.names.indexOf(name)));
    }

    @Override
    public DataStructureNode clear() {
        this.nodes.clear();
        if (this.names != null) {
            this.names.clear();
        }
        return this;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public String keyNameAt(int index) {
        if (this.names == null) {
            return null;
        }
        return this.names.get(index);
    }

    @Override
    public List<DataStructureNode.KeyValue> getKeyValuePairs() {
        ArrayList<DataStructureNode.KeyValue> l = new ArrayList<DataStructureNode.KeyValue>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            l.add(new DataStructureNode.KeyValue(this.names != null ? this.getKeyNames().get(i) : null, this.getNodes().get(i)));
        }
        return l;
    }

    @Override
    public List<String> getKeyNames() {
        return this.names != null ? Collections.unmodifiableList(this.names) : Collections.nCopies(this.size(), null);
    }

    @Override
    public List<DataStructureNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    @Override
    public TupleNode mutable() {
        return this;
    }
}

