/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.node;

import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.node.ValueNode;
import io.xpipe.core.data.type.DataType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class DataStructureNode
implements Iterable<DataStructureNode> {
    public static final Integer KEY_TABLE_NAME = 1;
    public static final Integer KEY_ROW_NAME = 2;
    public static final Integer BOOLEAN_TRUE = 3;
    public static final Integer IS_BOOLEAN = 4;
    public static final Integer BOOLEAN_FALSE = 5;
    public static final Integer INTEGER_VALUE = 6;
    public static final Integer IS_NULL = 7;
    public static final Integer IS_INTEGER = 9;
    public static final Integer IS_DECIMAL = 10;
    public static final Integer DECIMAL_VALUE = 11;
    public static final Integer IS_TEXT = 12;
    public static final Integer IS_INSTANT = 13;
    public static final Integer IS_BINARY = 14;
    public static final Integer IS_DATE = 15;
    public static final Integer DATE_VALUE = 16;
    public static final Integer IS_CURRENCY = 17;
    public static final Integer CURRENCY_CODE = 18;
    private Map<Integer, String> metaAttributes;

    public void clearMetaAttributes() {
        this.metaAttributes = null;
        if (this.isTuple() || this.isArray()) {
            this.getNodes().forEach((? super T dataStructureNode) -> dataStructureNode.clearMetaAttributes());
        }
    }

    public Map<Integer, String> getMetaAttributes() {
        return this.metaAttributes != null ? Collections.unmodifiableMap(this.metaAttributes) : null;
    }

    public DataStructureNode tag(Integer key) {
        if (this.metaAttributes == null) {
            this.metaAttributes = new HashMap<Integer, String>();
        }
        this.metaAttributes.put(key, null);
        return this;
    }

    public DataStructureNode tag(Map<Integer, String> metaAttributes) {
        if (metaAttributes == null) {
            return this;
        }
        if (this.metaAttributes == null) {
            this.metaAttributes = new HashMap<Integer, String>();
        }
        this.metaAttributes.putAll(metaAttributes);
        return this;
    }

    public DataStructureNode tag(Integer key, Object value) {
        if (this.metaAttributes == null) {
            this.metaAttributes = new HashMap<Integer, String>();
        }
        this.metaAttributes.put(key, value.toString());
        return this;
    }

    public String getMetaAttribute(Integer key) {
        if (this.metaAttributes == null) {
            return null;
        }
        return this.metaAttributes.get(key);
    }

    public boolean hasMetaAttribute(Integer key) {
        if (this.metaAttributes == null) {
            return false;
        }
        return this.metaAttributes.containsKey(key);
    }

    public DataStructureNode mutable() {
        return this;
    }

    public String keyNameAt(int index) {
        throw this.unsupported("key name at");
    }

    public List<KeyValue> getKeyValuePairs() {
        throw this.unsupported("get key value pairs");
    }

    public List<String> getKeyNames() {
        throw this.unsupported("get key names");
    }

    public List<DataStructureNode> getNodes() {
        throw this.unsupported("get nodes");
    }

    protected abstract String getName();

    protected UnsupportedOperationException unsupported(String s) {
        return new UnsupportedOperationException(this.getName() + " does not support " + s);
    }

    public abstract boolean isMutable();

    public String toString() {
        return this.toString(0);
    }

    public DataStructureNode clear() {
        throw this.unsupported("clear");
    }

    public String metaToString() {
        return "(" + (this.metaAttributes != null ? this.metaAttributes.entrySet().stream().sorted(Comparator.comparingInt(entry -> (Integer)entry.getKey())).map(e -> e.getValue() != null ? String.valueOf(e.getKey()) + ":" + (String)e.getValue() : ((Integer)e.getKey()).toString()).collect(Collectors.joining("|")) : "") + ")";
    }

    public abstract String toString(int var1);

    public boolean isTuple() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public DataStructureNode set(int index, DataStructureNode node) {
        throw this.unsupported("set at index");
    }

    public final ValueNode asValue() {
        if (!this.isValue()) {
            throw new UnsupportedOperationException(this.getName() + " is not a value node");
        }
        return (ValueNode)this;
    }

    public final TupleNode asTuple() {
        if (!this.isTuple()) {
            throw new UnsupportedOperationException(this.getName() + " is not a tuple node");
        }
        return (TupleNode)this;
    }

    public final ArrayNode asArray() {
        if (!this.isArray()) {
            throw new UnsupportedOperationException(this.getName() + " is not an array node");
        }
        return (ArrayNode)this;
    }

    public DataStructureNode put(String keyName, DataStructureNode node) {
        throw this.unsupported("put node with key");
    }

    public DataStructureNode put(DataStructureNode node) {
        throw this.unsupported("put node");
    }

    public DataStructureNode remove(int index) {
        throw this.unsupported("index remove");
    }

    public DataStructureNode remove(String keyName) {
        throw this.unsupported("key remove");
    }

    public int size() {
        throw this.unsupported("size computation");
    }

    public abstract DataType determineDataType();

    public DataStructureNode at(int index) {
        throw this.unsupported("integer indexing");
    }

    public DataStructureNode forKey(String name) {
        throw this.unsupported("name indexing");
    }

    public Optional<DataStructureNode> forKeyIfPresent(String name) {
        throw this.unsupported("name indexing");
    }

    public int asInt() {
        throw this.unsupported("integer conversion");
    }

    public String asString() {
        throw this.unsupported("string conversion");
    }

    public Stream<DataStructureNode> stream() {
        throw this.unsupported("stream creation");
    }

    @Override
    public void forEach(Consumer<? super DataStructureNode> action) {
        throw this.unsupported("for each");
    }

    @Override
    public Spliterator<DataStructureNode> spliterator() {
        throw this.unsupported("spliterator creation");
    }

    @Override
    public Iterator<DataStructureNode> iterator() {
        throw this.unsupported("iterator creation");
    }

    public record KeyValue(String key, DataStructureNode value) {
    }
}

