/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.node;

import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.SimpleArrayNode;
import io.xpipe.core.data.type.ArrayType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class ArrayNode
extends DataStructureNode {
    protected ArrayNode() {
    }

    public static ArrayNode empty() {
        return ArrayNode.of(List.of());
    }

    public static ArrayNode of(DataStructureNode ... dsn) {
        return ArrayNode.of(List.of(dsn));
    }

    public static ArrayNode of(List<DataStructureNode> nodes) {
        return new SimpleArrayNode(nodes);
    }

    public boolean equals(Object o) {
        boolean toReturn;
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayNode)) {
            return false;
        }
        ArrayNode that = (ArrayNode)o;
        boolean bl = toReturn = this.getNodes().equals(that.getNodes()) && Objects.equals(this.getMetaAttributes(), that.getMetaAttributes());
        if (!toReturn) {
            return false;
        }
        return toReturn;
    }

    public int hashCode() {
        return Objects.hash(this.getNodes(), this.getMetaAttributes());
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    protected final String getName() {
        return "array node";
    }

    @Override
    public final String toString(int indent) {
        String content = this.getNodes().stream().map(n -> n.toString(indent)).collect(Collectors.joining(", "));
        return "[" + content + "] " + this.metaToString();
    }

    @Override
    public final ArrayType determineDataType() {
        return ArrayType.ofSharedType(this.getNodes().stream().map(DataStructureNode::determineDataType).toList());
    }
}

