/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.data.generic;

import io.xpipe.core.data.generic.GenericAbstractReader;
import io.xpipe.core.data.generic.GenericArrayReader;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.SimpleTupleNode;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.node.ValueNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenericTupleReader
implements GenericAbstractReader {
    private boolean initialized;
    private int length;
    private List<String> names;
    private List<DataStructureNode> nodes;
    private int currentIndex = 0;
    private GenericAbstractReader currentReader;
    private DataStructureNode created;

    public static GenericTupleReader newReader(int length) {
        GenericTupleReader tr = new GenericTupleReader();
        tr.onTupleStart(length);
        return tr;
    }

    private boolean hasReader() {
        return this.currentReader != null;
    }

    private void init(int length) {
        this.length = length;
        this.names = new ArrayList<String>(length);
        this.nodes = new ArrayList<DataStructureNode>(length);
        this.initialized = true;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void putNode(DataStructureNode node) {
        if (this.names.size() == this.nodes.size()) {
            this.names.add(null);
        }
        this.nodes.add(node);
        ++this.currentIndex;
    }

    private boolean filled() {
        return this.currentIndex == this.length;
    }

    @Override
    public void onName(String name) {
        if (this.hasReader()) {
            this.currentReader.onName(name);
            return;
        }
        if (this.filled()) {
            throw new IllegalStateException("Tuple is full but got another name");
        }
        if (this.names.size() - this.nodes.size() == 1) {
            throw new IllegalStateException("Tuple is waiting for a node but got another name");
        }
        this.names.add(name);
    }

    @Override
    public void onArrayStart(int length) {
        if (this.hasReader()) {
            this.currentReader.onArrayStart(length);
            return;
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("Expected tuple start but got array start");
        }
        this.currentReader = GenericArrayReader.newReader(length);
    }

    @Override
    public void onArrayEnd(Map<Integer, String> metaAttributes) {
        if (this.hasReader()) {
            this.currentReader.onArrayEnd(metaAttributes);
            if (this.currentReader.isDone()) {
                this.putNode(this.currentReader.create());
                this.currentReader = null;
            }
            return;
        }
        throw new IllegalStateException("Expected tuple end but got array end");
    }

    @Override
    public void onTupleStart(int length) {
        if (this.hasReader()) {
            this.currentReader.onTupleStart(length);
            return;
        }
        if (!this.isInitialized()) {
            this.init(length);
            return;
        }
        this.currentReader = GenericTupleReader.newReader(length);
    }

    @Override
    public void onTupleEnd(Map<Integer, String> metaAttributes) {
        if (this.hasReader()) {
            this.currentReader.onTupleEnd(metaAttributes);
            if (this.currentReader.isDone()) {
                this.putNode(this.currentReader.create());
                this.currentReader = null;
            }
            return;
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("Expected tuple start but got tuple end");
        }
        if (!this.filled()) {
            throw new IllegalStateException("Tuple ended but is not full yet");
        }
        this.created = TupleNode.of(this.names, this.nodes);
    }

    @Override
    public void onValue(byte[] value, Map<Integer, String> metaAttributes) {
        if (this.currentReader != null) {
            this.currentReader.onValue(value, metaAttributes);
            return;
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("Expected tuple start but got value");
        }
        if (this.filled()) {
            throw new IllegalStateException("Tuple is full but got another value");
        }
        this.putNode(ValueNode.of(value).tag(metaAttributes));
    }

    @Override
    public boolean isDone() {
        return this.filled() && this.created != null;
    }

    @Override
    public DataStructureNode create() {
        if (!this.isDone()) {
            throw new IllegalStateException();
        }
        return SimpleTupleNode.of(this.names, this.nodes);
    }
}

