/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.charsetter;

import io.xpipe.core.charsetter.CharsetterContext;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class CharsetterUniverse {
    private final List<Charset> charsets;

    public static CharsetterUniverse create(CharsetterContext ctx) {
        ArrayList<Charset> cs = new ArrayList<Charset>();
        cs.add(StandardCharsets.UTF_8);
        Charset system = Charset.forName(ctx.getSystemCharsetName());
        cs.add(system);
        List<Charset> observed = ctx.getObservedCharsets().stream().map(Charset::forName).toList();
        cs.addAll(observed);
        return new CharsetterUniverse(cs);
    }

    public List<Charset> getCharsets() {
        return this.charsets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharsetterUniverse)) {
            return false;
        }
        CharsetterUniverse other = (CharsetterUniverse)o;
        List<Charset> this$charsets = this.getCharsets();
        List<Charset> other$charsets = other.getCharsets();
        return !(this$charsets == null ? other$charsets != null : !((Object)this$charsets).equals(other$charsets));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Charset> $charsets = this.getCharsets();
        result = result * 59 + ($charsets == null ? 43 : ((Object)$charsets).hashCode());
        return result;
    }

    public String toString() {
        return "CharsetterUniverse(charsets=" + String.valueOf(this.getCharsets()) + ")";
    }

    public CharsetterUniverse(List<Charset> charsets) {
        this.charsets = charsets;
    }
}

