/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.impl.FileNames;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ShellControl;
import java.io.IOException;
import java.nio.file.Path;

public class XPipeTempDirectory {
    public static Path getLocal() {
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            return Path.of(System.getenv("TEMP"), new String[0]).resolve("xpipe");
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return Path.of("/tmp/xpipe", new String[0]);
        }
        return Path.of(System.getenv("TMPDIR"), "xpipe");
    }

    public static String get(ShellControl proc) throws Exception {
        String base = proc.getOsType().getTempDirectory(proc);
        String dir = FileNames.join(base, "xpipe");
        if (!proc.executeBooleanSimpleCommand(proc.getShellDialect().getFileExistsCommand(dir))) {
            proc.executeSimpleCommand(proc.getShellDialect().flatten(proc.getShellDialect().getMkdirsCommand(dir)), "Unable to access or create temporary directory " + dir);
            if (proc.getOsType().equals(OsType.LINUX) || proc.getOsType().equals(OsType.MACOS)) {
                proc.executeSimpleCommand("chmod -f 777 \"" + dir + "\"");
            }
        }
        return dir;
    }

    public static void clear(ShellControl proc) throws Exception {
        String dir = XPipeTempDirectory.get(proc);
        if (!proc.executeBooleanSimpleCommand(proc.getShellDialect().getFileDeleteCommand(dir))) {
            throw new IOException("Unable to delete temporary directory " + dir);
        }
    }
}

