/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.process.OsType;
import io.xpipe.core.util.UuidHelper;
import io.xpipe.core.util.XPipeTempDirectory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.UUID;

public final class XPipeSession {
    private final boolean isNewSystemSession;
    private final UUID sessionId;
    private final UUID buildSessionId;
    private final UUID systemSessionId;
    private static XPipeSession INSTANCE;

    public static void init(UUID buildSessionId) {
        if (INSTANCE != null) {
            return;
        }
        Path sessionFile = XPipeTempDirectory.getLocal().resolve("xpipe_session");
        boolean isNewSystemSession = !Files.exists(sessionFile, new LinkOption[0]);
        UUID systemSessionId = isNewSystemSession ? UUID.randomUUID() : UuidHelper.parse(() -> Files.readString(sessionFile)).orElse(UUID.randomUUID());
        try {
            if (OsType.getLocal().equals(OsType.WINDOWS)) {
                Path pf = Path.of("C:\\pagefile.sys", new String[0]);
                BasicFileAttributes attr = Files.readAttributes(pf, BasicFileAttributes.class, new LinkOption[0]);
                UUID timeUuid = UUID.nameUUIDFromBytes(attr.creationTime().toInstant().toString().getBytes());
                isNewSystemSession = isNewSystemSession && timeUuid.equals(systemSessionId);
                systemSessionId = timeUuid;
            }
        }
        catch (Exception ex) {
            isNewSystemSession = true;
            systemSessionId = UUID.randomUUID();
        }
        try {
            Files.writeString(sessionFile, (CharSequence)systemSessionId.toString(), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        INSTANCE = new XPipeSession(isNewSystemSession, UUID.randomUUID(), buildSessionId, systemSessionId);
    }

    public static XPipeSession get() {
        return INSTANCE;
    }

    public XPipeSession(boolean isNewSystemSession, UUID sessionId, UUID buildSessionId, UUID systemSessionId) {
        this.isNewSystemSession = isNewSystemSession;
        this.sessionId = sessionId;
        this.buildSessionId = buildSessionId;
        this.systemSessionId = systemSessionId;
    }

    public boolean isNewSystemSession() {
        return this.isNewSystemSession;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public UUID getBuildSessionId() {
        return this.buildSessionId;
    }

    public UUID getSystemSessionId() {
        return this.systemSessionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XPipeSession)) {
            return false;
        }
        XPipeSession other = (XPipeSession)o;
        if (this.isNewSystemSession() != other.isNewSystemSession()) {
            return false;
        }
        UUID this$sessionId = this.getSessionId();
        UUID other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        UUID this$buildSessionId = this.getBuildSessionId();
        UUID other$buildSessionId = other.getBuildSessionId();
        if (this$buildSessionId == null ? other$buildSessionId != null : !((Object)this$buildSessionId).equals(other$buildSessionId)) {
            return false;
        }
        UUID this$systemSessionId = this.getSystemSessionId();
        UUID other$systemSessionId = other.getSystemSessionId();
        return !(this$systemSessionId == null ? other$systemSessionId != null : !((Object)this$systemSessionId).equals(other$systemSessionId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNewSystemSession() ? 79 : 97);
        UUID $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        UUID $buildSessionId = this.getBuildSessionId();
        result = result * 59 + ($buildSessionId == null ? 43 : ((Object)$buildSessionId).hashCode());
        UUID $systemSessionId = this.getSystemSessionId();
        result = result * 59 + ($systemSessionId == null ? 43 : ((Object)$systemSessionId).hashCode());
        return result;
    }

    public String toString() {
        return "XPipeSession(isNewSystemSession=" + this.isNewSystemSession() + ", sessionId=" + String.valueOf(this.getSessionId()) + ", buildSessionId=" + String.valueOf(this.getBuildSessionId()) + ", systemSessionId=" + String.valueOf(this.getSystemSessionId()) + ")";
    }
}

