/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.util.SecretProvider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Consumer;

public class SecretValue {
    String value;

    public static SecretValue encrypt(char[] c) {
        if (c == null) {
            return null;
        }
        ByteBuffer utf8 = StandardCharsets.UTF_8.encode(CharBuffer.wrap(c));
        byte[] bytes = new byte[utf8.limit()];
        utf8.get(bytes);
        Arrays.fill(c, '\u0000');
        bytes = SecretProvider.get().encrypt(bytes);
        String base64 = Base64.getEncoder().encodeToString(bytes);
        return new SecretValue(base64.replace("/", "-"));
    }

    public static SecretValue encrypt(String s) {
        if (s == null) {
            return null;
        }
        return SecretValue.encrypt(s.toCharArray());
    }

    public void withSecretValue(Consumer<char[]> con) {
        char[] chars = this.decryptChars();
        con.accept(chars);
        Arrays.fill(chars, '\u0000');
    }

    public String toString() {
        return "<secret>";
    }

    public String getEncryptedValue() {
        return this.value;
    }

    public char[] decryptChars() {
        try {
            byte[] bytes = Base64.getDecoder().decode(this.value.replace("-", "/"));
            bytes = SecretProvider.get().decrypt(bytes);
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes));
            char[] chars = new char[charBuffer.limit()];
            charBuffer.get(chars);
            return chars;
        }
        catch (Exception ex) {
            return new char[0];
        }
    }

    public String decrypt() {
        return new String(this.decryptChars());
    }

    public static SecretValue ofSecret(String s) {
        return new SecretValue(s);
    }

    public String getSecretValue() {
        return this.decrypt();
    }

    public SecretValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretValue)) {
            return false;
        }
        SecretValue other = (SecretValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecretValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

