/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import java.util.ServiceLoader;
import java.util.function.Consumer;

public interface ModuleLayerLoader {
    public static void loadAll(ModuleLayer layer, boolean hasDaemon, boolean prioritization, Consumer<Throwable> errorHandler) {
        ServiceLoader.load(layer, ModuleLayerLoader.class).stream().forEach(moduleLayerLoaderProvider -> {
            ModuleLayerLoader instance = (ModuleLayerLoader)moduleLayerLoaderProvider.get();
            try {
                if (instance.requiresFullDaemon() && !hasDaemon) {
                    return;
                }
                if (instance.prioritizeLoading() != prioritization) {
                    return;
                }
                instance.init(layer);
            }
            catch (Throwable t) {
                errorHandler.accept(t);
            }
        });
    }

    public void init(ModuleLayer var1);

    public boolean requiresFullDaemon();

    public boolean prioritizeLoading();
}

