/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public class JacksonMapper {
    private static final ObjectMapper BASE = new ObjectMapper();
    private static final ObjectMapper DEFAULT;
    private static ObjectMapper INSTANCE;
    private static boolean init;

    public static <T> T parse(String s, Class<T> c) throws JsonProcessingException {
        ObjectMapper mapper = JacksonMapper.getDefault();
        JsonNode tree = mapper.readTree(s);
        return (T)mapper.treeToValue((TreeNode)tree, c);
    }

    public static synchronized void configure(Consumer<ObjectMapper> mapper) {
        mapper.accept(INSTANCE);
    }

    public static synchronized void initClassBased() {
        JacksonMapper.initModularized(null);
    }

    public static synchronized void initModularized(ModuleLayer layer) {
        List<Module> MODULES = JacksonMapper.findModules(layer);
        INSTANCE.registerModules(MODULES);
        init = true;
    }

    private static List<Module> findModules(ModuleLayer layer) {
        ArrayList<Module> modules = new ArrayList<Module>();
        ServiceLoader<Module> loader = layer != null ? ServiceLoader.load(layer, Module.class) : ServiceLoader.load(Module.class);
        for (Module module : loader) {
            modules.add(module);
        }
        return modules;
    }

    public static ObjectMapper newMapper() {
        if (!JacksonMapper.isInit()) {
            return DEFAULT;
        }
        return INSTANCE.copy();
    }

    public static ObjectMapper getDefault() {
        if (!JacksonMapper.isInit()) {
            return DEFAULT;
        }
        return INSTANCE;
    }

    public static boolean isInit() {
        return init;
    }

    static {
        INSTANCE = new ObjectMapper();
        init = false;
        ObjectMapper objectMapper = BASE;
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
        List<Module> modules = JacksonMapper.findModules(ModuleLayer.boot());
        objectMapper.registerModules(modules);
        INSTANCE = BASE.copy();
        DEFAULT = BASE.copy();
    }
}

