/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.charsetter.NewLine;
import io.xpipe.core.process.OsType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Deobfuscator {
    public static void deobfuscate(Throwable throwable) {
        if (!System.getenv().containsKey("XPIPE_MAPPING")) {
            return;
        }
        String deobf = Deobfuscator.deobfuscateToString(throwable);
        try {
            Pattern tracePattern = Pattern.compile("\\s*at\\s+([\\w.$_]+)\\.([\\w$_]+)\\((.*):(\\d+)\\)(\\n|\\r\\n)");
            Matcher traceMatcher = tracePattern.matcher(deobf);
            ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
            while (traceMatcher.find()) {
                String className = traceMatcher.group(1);
                String methodName = traceMatcher.group(2);
                String sourceFile = traceMatcher.group(3);
                int lineNum = Integer.parseInt(traceMatcher.group(4));
                stackTrace.add(new StackTraceElement(className, methodName, sourceFile, lineNum));
            }
            throwable.setStackTrace((StackTraceElement[])stackTrace.toArray(StackTraceElement[]::new));
            if (throwable.getCause() != null && throwable.getCause() != throwable) {
                Deobfuscator.deobfuscate(throwable.getCause());
            }
            for (Throwable suppressed : throwable.getSuppressed()) {
                if (suppressed == throwable) continue;
                Deobfuscator.deobfuscate(suppressed);
            }
        }
        catch (Throwable ex) {
            System.err.println("Deobfuscation failed");
            ex.printStackTrace();
        }
    }

    public static String deobfuscateToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();
        stackTrace = stackTrace.replaceAll("at .+/(.+)", "at $1");
        try {
            if (!Deobfuscator.canDeobfuscate()) {
                return stackTrace;
            }
            Path file = Files.createTempFile("xpipe_stracktrace", null, new FileAttribute[0]);
            Files.writeString(file, (CharSequence)stackTrace, new OpenOption[0]);
            ProcessBuilder proc = new ProcessBuilder("retrace." + (OsType.getLocal().equals(OsType.WINDOWS) ? "bat" : "sh"), System.getenv("XPIPE_MAPPING"), file.toString()).redirectErrorStream(true);
            Process active = proc.start();
            String out = new String(active.getInputStream().readAllBytes()).replaceAll("\r\n", NewLine.LF.getNewLineString());
            int code = active.waitFor();
            if (code == 0) {
                return out;
            }
            System.err.println("Deobfuscation failed: " + out);
        }
        catch (Exception ex) {
            System.err.println("Deobfuscation failed");
            return stackTrace;
        }
        return stackTrace;
    }

    public static void printStackTrace(Throwable t) {
        String s = Deobfuscator.deobfuscateToString(t);
        System.err.println(s);
    }

    private static boolean canDeobfuscate() throws Exception {
        if (!System.getenv().containsKey("XPIPE_MAPPING")) {
            return false;
        }
        Path file = Path.of(System.getenv("XPIPE_MAPPING"), new String[0]);
        return Files.exists(file, new LinkOption[0]);
    }
}

