/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.impl.LocalStore;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.store.ConnectionFileSystem;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.FileSystem;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.LaunchableStore;
import io.xpipe.core.store.StatefulDataStore;
import java.nio.charset.Charset;

public interface ShellStore
extends DataStore,
StatefulDataStore,
LaunchableStore,
FileSystemStore {
    public static ShellStore createLocal() {
        return new LocalStore();
    }

    public static boolean isLocal(ShellStore s) {
        return s instanceof LocalStore;
    }

    @Override
    default public FileSystem createFileSystem() {
        return new ConnectionFileSystem(this.create(), this);
    }

    @Override
    default public String prepareLaunchCommand() throws Exception {
        return this.create().prepareTerminalOpen();
    }

    default public ShellControl create() {
        ShellControl pc = this.createControl();
        pc.onInit(processControl -> {
            this.setState("type", processControl.getShellDialect());
            this.setState("os", processControl.getOsType());
            this.setState("charset", processControl.getCharset());
        });
        return pc;
    }

    default public ShellDialect getShellType() {
        return this.getState("type", ShellDialect.class, null);
    }

    default public OsType getOsType() {
        return this.getState("os", OsType.class, null);
    }

    default public Charset getCharset() {
        return this.getState("charset", Charset.class, null);
    }

    public ShellControl createControl();

    default public ShellDialect determineType() throws Exception {
        try (ShellControl pc = this.create().start();){
            ShellDialect shellDialect = pc.getShellDialect();
            return shellDialect;
        }
    }

    @Override
    default public void validate() throws Exception {
        ShellControl pc = this.create().start();
        if (pc != null) {
            pc.close();
        }
    }

    default public String queryMachineName() throws Exception {
        try (ShellControl pc = this.create().start();){
            OsType operatingSystem = pc.getOsType();
            String string = operatingSystem.determineOperatingSystemName(pc);
            return string;
        }
    }
}

