/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.impl.FileNames;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FileSystemStore;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

public interface FileSystem
extends Closeable,
AutoCloseable {
    public FileSystemStore getStore();

    public Optional<ShellControl> getShell();

    public FileSystem open() throws Exception;

    public InputStream openInput(String var1) throws Exception;

    public OutputStream openOutput(String var1) throws Exception;

    public boolean exists(String var1) throws Exception;

    public void delete(String var1) throws Exception;

    public void copy(String var1, String var2) throws Exception;

    public void move(String var1, String var2) throws Exception;

    public boolean mkdirs(String var1) throws Exception;

    public void touch(String var1) throws Exception;

    public boolean isDirectory(String var1) throws Exception;

    public Stream<FileEntry> listFiles(String var1) throws Exception;

    default public Stream<FileEntry> listFilesRecursively(String file) throws Exception {
        return this.listFiles(file).flatMap(fileEntry -> {
            if (!fileEntry.isDirectory()) {
                return Stream.of(fileEntry);
            }
            try {
                return Stream.concat(Stream.of(fileEntry), this.listFilesRecursively(fileEntry.getPath()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public List<String> listRoots() throws Exception;

    public static final class FileEntry {
        @NonNull
        private final FileSystem fileSystem;
        @NonNull
        private final String path;
        private final Instant date;
        private final boolean directory;
        private final boolean hidden;
        private final Boolean executable;
        private final long size;

        public FileEntry(@NonNull FileSystem fileSystem, @NonNull String path, Instant date, boolean directory, boolean hidden, Boolean executable, long size) {
            if (fileSystem == null) {
                throw new NullPointerException("fileSystem is marked non-null but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.fileSystem = fileSystem;
            this.path = directory ? FileNames.toDirectory(path) : path;
            this.date = date;
            this.directory = directory;
            this.hidden = hidden;
            this.executable = executable;
            this.size = size;
        }

        @NonNull
        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }

        public Instant getDate() {
            return this.date;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public Boolean getExecutable() {
            return this.executable;
        }

        public long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileEntry)) {
                return false;
            }
            FileEntry other = (FileEntry)o;
            if (this.isDirectory() != other.isDirectory()) {
                return false;
            }
            if (this.isHidden() != other.isHidden()) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            Boolean this$executable = this.getExecutable();
            Boolean other$executable = other.getExecutable();
            if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
                return false;
            }
            FileSystem this$fileSystem = this.getFileSystem();
            FileSystem other$fileSystem = other.getFileSystem();
            if (this$fileSystem == null ? other$fileSystem != null : !this$fileSystem.equals(other$fileSystem)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Instant this$date = this.getDate();
            Instant other$date = other.getDate();
            return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDirectory() ? 79 : 97);
            result = result * 59 + (this.isHidden() ? 79 : 97);
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            Boolean $executable = this.getExecutable();
            result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
            FileSystem $fileSystem = this.getFileSystem();
            result = result * 59 + ($fileSystem == null ? 43 : $fileSystem.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Instant $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            return result;
        }

        public String toString() {
            return "FileSystem.FileEntry(fileSystem=" + String.valueOf(this.getFileSystem()) + ", path=" + this.getPath() + ", date=" + String.valueOf(this.getDate()) + ", directory=" + this.isDirectory() + ", hidden=" + this.isHidden() + ", executable=" + this.getExecutable() + ", size=" + this.getSize() + ")";
        }
    }
}

