/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FileSystem;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.ShellStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ConnectionFileSystem
implements FileSystem {
    @JsonIgnore
    private final ShellControl shellControl;
    @JsonIgnore
    private final ShellStore store;

    public ConnectionFileSystem(ShellControl shellControl, ShellStore store) {
        this.shellControl = shellControl;
        this.store = store;
    }

    @Override
    public List<String> listRoots() throws Exception {
        return this.shellControl.getShellDialect().listRoots(this.shellControl).toList();
    }

    @Override
    public boolean isDirectory(String file) throws Exception {
        return true;
    }

    @Override
    public Stream<FileSystem.FileEntry> listFiles(String file) throws Exception {
        return this.shellControl.getShellDialect().listFiles(this, this.shellControl, file);
    }

    @Override
    public FileSystemStore getStore() {
        return this.store;
    }

    @Override
    public Optional<ShellControl> getShell() {
        return Optional.of(this.shellControl);
    }

    @Override
    public FileSystem open() throws Exception {
        this.shellControl.start();
        return this;
    }

    @Override
    public InputStream openInput(String file) throws Exception {
        return this.shellControl.command(proc -> proc.getShellDialect().getFileReadCommand(proc.getOsType().normalizeFileName(file))).startExternalStdout();
    }

    @Override
    public OutputStream openOutput(String file) throws Exception {
        return this.shellControl.getShellDialect().createStreamFileWriteCommand(this.shellControl, this.shellControl.getOsType().normalizeFileName(file)).startExternalStdin();
    }

    @Override
    public boolean exists(String file) throws Exception {
        try (CommandControl pc = this.shellControl.command(proc -> proc.getShellDialect().getFileExistsCommand(proc.getOsType().normalizeFileName(file))).start();){
            boolean bl = pc.discardAndCheckExit();
            return bl;
        }
    }

    @Override
    public void delete(String file) throws Exception {
        try (CommandControl pc = this.shellControl.command(proc -> proc.getShellDialect().getFileDeleteCommand(proc.getOsType().normalizeFileName(file))).start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public void copy(String file, String newFile) throws Exception {
        try (CommandControl pc = this.shellControl.command(proc -> proc.getShellDialect().getFileCopyCommand(proc.getOsType().normalizeFileName(file), proc.getOsType().normalizeFileName(newFile))).complex().start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public void move(String file, String newFile) throws Exception {
        try (CommandControl pc = this.shellControl.command(proc -> proc.getShellDialect().getFileMoveCommand(proc.getOsType().normalizeFileName(file), proc.getOsType().normalizeFileName(newFile))).complex().start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public boolean mkdirs(String file) throws Exception {
        try (CommandControl pc = this.shellControl.command(proc -> proc.getShellDialect().flatten(proc.getShellDialect().getMkdirsCommand(proc.getOsType().normalizeFileName(file)))).start();){
            boolean bl = pc.discardAndCheckExit();
            return bl;
        }
    }

    @Override
    public void touch(String file) throws Exception {
        try (CommandControl pc = this.shellControl.command(proc -> proc.getShellDialect().getFileTouchCommand(proc.getOsType().normalizeFileName(file))).complex().start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public void close() throws IOException {
        this.shellControl.close();
    }

    public ShellControl getShellControl() {
        return this.shellControl;
    }
}

