/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.DataStructureNodeAcceptor;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.data.typed.TypedDataStreamWriter;
import io.xpipe.core.impl.BufferedTableReadConnection;
import io.xpipe.core.impl.LimitTableReadConnection;
import io.xpipe.core.source.DataSourceConnection;
import io.xpipe.core.source.DataSourceReadConnection;
import io.xpipe.core.source.TableMapping;
import io.xpipe.core.source.TableWriteConnection;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicInteger;

public interface TableReadConnection
extends DataSourceReadConnection {
    public static TableReadConnection empty() {
        return new TableReadConnection(){

            @Override
            public boolean canRead() throws Exception {
                return true;
            }

            @Override
            public TupleType getDataType() {
                return TupleType.empty();
            }

            @Override
            public OptionalInt getRowCount() throws Exception {
                return OptionalInt.empty();
            }

            @Override
            public void withRows(DataStructureNodeAcceptor<TupleNode> lineAcceptor) throws Exception {
            }

            @Override
            public ArrayNode readRows(int maxLines) throws Exception {
                return ArrayNode.of(new DataStructureNode[0]);
            }
        };
    }

    public TupleType getDataType();

    default public OptionalInt getRowCount() throws Exception {
        return OptionalInt.empty();
    }

    default public TableReadConnection limit(int limit) {
        return new LimitTableReadConnection(this, limit);
    }

    default public TableReadConnection buffered() throws Exception {
        return this.buffered(Integer.MAX_VALUE);
    }

    default public TableReadConnection buffered(int limit) throws Exception {
        return new BufferedTableReadConnection(this, limit);
    }

    public void withRows(DataStructureNodeAcceptor<TupleNode> var1) throws Exception;

    default public ArrayNode readRows(int maxLines) throws Exception {
        ArrayList<DataStructureNode> list = new ArrayList<DataStructureNode>();
        AtomicInteger rowCounter = new AtomicInteger();
        this.withRows(t -> {
            list.add(t);
            rowCounter.getAndIncrement();
            return rowCounter.get() != maxLines;
        });
        return ArrayNode.of(list);
    }

    default public void forwardRows(OutputStream out, int maxLines) throws Exception {
        if (maxLines == 0) {
            return;
        }
        TupleType dataType = this.getDataType();
        AtomicInteger rowCounter = new AtomicInteger();
        this.withRows(l -> {
            TypedDataStreamWriter.writeStructure(out, l, dataType);
            rowCounter.getAndIncrement();
            return rowCounter.get() != maxLines;
        });
    }

    @Override
    default public void forward(DataSourceConnection con) throws Exception {
        this.forwardAndCount(con);
    }

    default public int forwardAndCount(DataSourceConnection con) throws Exception {
        TupleType inputType = this.getDataType();
        TableWriteConnection tCon = (TableWriteConnection)con;
        Optional<TableMapping> mapping = tCon.createMapping(inputType);
        DataStructureNodeAcceptor<TupleNode> acceptor = tCon.writeLinesAcceptor(mapping.orElseThrow());
        AtomicInteger counter = new AtomicInteger();
        this.withRows(acc -> {
            if (!acceptor.accept((TupleNode)acc)) {
                return false;
            }
            counter.getAndIncrement();
            return true;
        });
        return counter.get();
    }
}

