/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.xpipe.core.data.type.TupleType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public class TableMapping {
    protected final Integer[] columMap;
    private final TupleType inputType;
    private final TupleType outputType;

    @JsonCreator
    public TableMapping(TupleType inputType, TupleType outputType, Integer[] columMap) {
        this.inputType = inputType;
        this.outputType = outputType;
        this.columMap = columMap;
    }

    private static Integer[] range(int size) {
        Integer[] array = new Integer[size];
        for (int i = 0; i < size; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static TableMapping empty(TupleType inputType) {
        return new TableMapping(inputType, TupleType.empty(), new Integer[inputType.getSize()]);
    }

    public static TableMapping createIdentity(TupleType inputType) {
        return new TableMapping(inputType, inputType, TableMapping.range(inputType.getSize()));
    }

    public static Optional<TableMapping> createBasic(TupleType inputType, TupleType outputType) {
        if (inputType.hasAllNames()) {
            Integer[] array = new Integer[inputType.getSize()];
            for (int i = 0; i < inputType.getNames().size(); ++i) {
                OptionalInt map = TableMapping.mapColumnName(inputType.getNames().get(i), outputType.getNames());
                array[i] = map.isPresent() ? Integer.valueOf(map.getAsInt()) : null;
            }
            return Optional.of(new TableMapping(inputType, outputType, array));
        }
        if ((!inputType.hasAllNames() || outputType.hasAllNames()) && inputType.getSize() == outputType.getSize()) {
            return Optional.of(new TableMapping(inputType, outputType, TableMapping.range(inputType.getSize())));
        }
        return Optional.empty();
    }

    private static OptionalInt mapColumnName(String inputName, List<String> outputNames) {
        for (int i = 0; i < outputNames.size(); ++i) {
            if (outputNames.get(i) == null || !outputNames.get(i).trim().equalsIgnoreCase(inputName.trim())) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public boolean isIdentity() {
        return this.inputType.equals(this.outputType) && Arrays.equals((Object[])this.columMap, (Object[])TableMapping.range(this.getInputType().getSize()));
    }

    public boolean isComplete() {
        return IntStream.range(0, this.outputType.getSize()).allMatch(value -> this.inverseMap(value).isPresent());
    }

    public boolean isComplete(List<String> outputNames) {
        return IntStream.range(0, this.outputType.getSize()).filter(i -> outputNames.contains(this.outputType.getNames().get(i))).allMatch(value -> this.inverseMap(value).isPresent());
    }

    public TableMapping sub(List<String> outputNames) {
        Integer[] array = Arrays.copyOf(this.columMap, this.columMap.length);
        for (int i = 0; i < this.inputType.getSize(); ++i) {
            OptionalInt mapped = this.map(i);
            if (!mapped.isPresent() || outputNames.contains(this.outputType.getNames().get(mapped.getAsInt()))) continue;
            array[i] = null;
        }
        return new TableMapping(this.inputType, this.outputType, array);
    }

    public OptionalInt inverseMap(int outputColumn) {
        for (int i = 0; i < this.inputType.getNames().size(); ++i) {
            if (this.map(i).orElse(-1) != outputColumn) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public OptionalInt map(int inputColumn) {
        return this.columMap[inputColumn] != null ? OptionalInt.of(this.columMap[inputColumn]) : OptionalInt.empty();
    }

    public Integer[] getColumMap() {
        return this.columMap;
    }

    public TupleType getInputType() {
        return this.inputType;
    }

    public TupleType getOutputType() {
        return this.outputType;
    }
}

