/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.RawReadConnection;
import io.xpipe.core.source.RawWriteConnection;
import io.xpipe.core.source.WriteMode;
import io.xpipe.core.store.DataStore;

public abstract class RawDataSource<DS extends DataStore>
extends DataSource<DS> {
    private static final int MAX_BYTES_READ = 100000;

    @Override
    public DataSourceType getType() {
        return DataSourceType.RAW;
    }

    @Override
    public final RawReadConnection openReadConnection() throws Exception {
        if (!this.isComplete()) {
            throw new UnsupportedOperationException();
        }
        return this.newReadConnection();
    }

    @Override
    public final RawWriteConnection openWriteConnection(WriteMode mode) throws Exception {
        RawWriteConnection con = this.newWriteConnection(mode);
        if (con == null) {
            throw new UnsupportedOperationException(mode.getId());
        }
        return con;
    }

    protected abstract RawWriteConnection newWriteConnection(WriteMode var1);

    protected abstract RawReadConnection newReadConnection();

    protected RawDataSource(RawDataSourceBuilder<DS, ?, ?> b) {
        super(b);
    }

    public static abstract class RawDataSourceBuilder<DS extends DataStore, C extends RawDataSource<DS>, B extends RawDataSourceBuilder<DS, C, B>>
    extends DataSource.DataSourceBuilder<DS, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "RawDataSource.RawDataSourceBuilder(super=" + super.toString() + ")";
        }
    }
}

