/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.source;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.xpipe.core.charsetter.NewLine;
import io.xpipe.core.charsetter.StreamCharset;
import io.xpipe.core.impl.TextSource;
import io.xpipe.core.impl.XpbtSource;
import io.xpipe.core.source.DataSourceConnection;
import io.xpipe.core.source.DataSourceReadConnection;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.WriteMode;
import io.xpipe.core.store.DataFlow;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.StreamDataStore;
import io.xpipe.core.util.JacksonMapper;
import io.xpipe.core.util.JacksonizedValue;
import java.util.List;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class DataSource<DS extends DataStore>
extends JacksonizedValue {
    protected DS store;

    public static DataSource<?> createInternalDataSource(DataSourceType t, DataStore store) {
        try {
            return switch (t) {
                default -> throw new IncompatibleClassChangeError();
                case DataSourceType.TABLE -> ((XpbtSource.XpbtSourceBuilder)XpbtSource.builder().store((StreamDataStore)store.asNeeded())).build();
                case DataSourceType.STRUCTURE -> null;
                case DataSourceType.TEXT -> ((TextSource.TextSourceBuilder)((TextSource.TextSourceBuilder)((TextSource.TextSourceBuilder)TextSource.builder().store((StreamDataStore)store.asNeeded())).newLine(NewLine.LF)).charset(StreamCharset.UTF8)).build();
                case DataSourceType.RAW -> null;
                case DataSourceType.COLLECTION -> null;
            };
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public boolean isComplete() {
        try {
            this.checkComplete();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void checkComplete() throws Exception {
        if (this.store == null) {
            throw new IllegalStateException("Store cannot be null");
        }
        this.store.checkComplete();
    }

    public void validate() throws Exception {
        this.store.validate();
    }

    public List<WriteMode> getAvailableWriteModes() {
        if (this.getFlow() == null) {
            return List.of();
        }
        if (this.getFlow() != null && (this.getFlow() == DataFlow.TRANSFORMER || this.getFlow() == DataFlow.INPUT)) {
            return List.of();
        }
        if (this.getFlow() != null && (this.getFlow() == DataFlow.OUTPUT || this.getFlow() == DataFlow.INPUT_OR_OUTPUT)) {
            return List.of(WriteMode.REPLACE);
        }
        return List.of(WriteMode.REPLACE, WriteMode.APPEND, WriteMode.PREPEND);
    }

    public DataFlow getFlow() {
        if (this.store == null) {
            return null;
        }
        return this.store.getFlow();
    }

    public <T extends DataSource<DS>> T copy() {
        ObjectMapper mapper = JacksonMapper.newMapper();
        TokenBuffer tb = new TokenBuffer((ObjectCodec)mapper, false);
        mapper.writeValue((JsonGenerator)tb, (Object)this);
        return (T)((DataSource)mapper.readValue(tb.asParser(), this.getClass()));
    }

    public DataSource<DS> withStore(DS store) {
        Object c = this.copy();
        ((DataSource)c).store = store;
        return c;
    }

    public final <DSD extends DataSource<?>> DSD asNeeded() {
        return (DSD)this;
    }

    public Optional<String> determineDefaultName() {
        return Optional.empty();
    }

    public DataSourceReadConnection openReadConnection() throws Exception {
        throw new UnsupportedOperationException();
    }

    public DataSourceConnection openWriteConnection(WriteMode mode) throws Exception {
        throw new UnsupportedOperationException();
    }

    public DS getStore() {
        return this.store;
    }

    public abstract DataSourceType getType();

    protected DataSource(DataSourceBuilder<DS, ?, ?> b) {
        super(b);
        this.store = b.store;
    }

    public static abstract class DataSourceBuilder<DS extends DataStore, C extends DataSource<DS>, B extends DataSourceBuilder<DS, C, B>>
    extends JacksonizedValue.JacksonizedValueBuilder<C, B> {
        private DS store;

        public B store(DS store) {
            this.store = store;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DataSource.DataSourceBuilder(super=" + super.toString() + ", store=" + String.valueOf(this.store) + ")";
        }
    }
}

