/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.util.ModuleLayerLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class ShellDialects {
    public static final List<ShellDialect> ALL = new ArrayList<ShellDialect>();
    public static ShellDialect POWERSHELL;
    public static ShellDialect CMD;
    public static ShellDialect SH;
    public static ShellDialect BASH;
    public static ShellDialect ZSH;

    private static ShellDialect byName(String name) {
        return ALL.stream().filter(shellType -> shellType.getId().equals(name)).findFirst().orElseThrow();
    }

    public static ShellDialect getPlatformDefault() {
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            return CMD;
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return BASH;
        }
        return ZSH;
    }

    public static class Loader
    implements ModuleLayerLoader {
        @Override
        public void init(ModuleLayer layer) {
            ServiceLoader.load(layer, ShellDialect.class).stream().forEach(moduleLayerLoaderProvider -> ALL.add((ShellDialect)moduleLayerLoaderProvider.get()));
            CMD = ShellDialects.byName("cmd");
            POWERSHELL = ShellDialects.byName("powershell");
            SH = ShellDialects.byName("sh");
            BASH = ShellDialects.byName("bash");
            ZSH = ShellDialects.byName("zsh");
        }

        @Override
        public boolean requiresFullDaemon() {
            return false;
        }

        @Override
        public boolean prioritizeLoading() {
            return true;
        }
    }
}

