/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.xpipe.core.charsetter.NewLine;
import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FileSystem;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface ShellDialect {
    public CommandControl createStreamFileWriteCommand(ShellControl var1, String var2);

    default public String getCdCommand(String directory) {
        return "cd \"" + directory + "\"";
    }

    default public String getPushdCommand(String directory) {
        return "pushd \"" + directory + "\"";
    }

    default public String getPopdCommand() {
        return "popd";
    }

    public String getScriptFileEnding();

    public String addInlineVariablesToCommand(Map<String, String> var1, String var2);

    public Stream<FileSystem.FileEntry> listFiles(FileSystem var1, ShellControl var2, String var3) throws Exception;

    public Stream<String> listRoots(ShellControl var1) throws Exception;

    public String getPauseCommand();

    public String prepareScriptContent(String var1);

    default public String flatten(List<String> command) {
        return command.stream().map(s -> !(!s.contains(" ") || s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) ? "\"" + s + "\"" : s).collect(Collectors.joining(" "));
    }

    default public String getExitCommand() {
        return "exit";
    }

    public String getExitCodeVariable();

    public String environmentVariable(String var1);

    default public String getConcatenationOperator() {
        return ";";
    }

    default public String getOrConcatenationOperator() {
        return "||";
    }

    public String getMakeExecutableCommand(String var1);

    default public String getScriptEchoCommand(String s) {
        return this.getEchoCommand(s, false);
    }

    public String getSetEnvironmentVariableCommand(String var1, String var2);

    public String getEchoCommand(String var1, boolean var2);

    public String getPrintVariableCommand(String var1);

    public String getPrintExitCodeCommand(String var1);

    default public String getPrintEnvironmentVariableCommand(String name) {
        return this.getPrintVariableCommand(name);
    }

    public String getNormalOpenCommand();

    public String getInitFileOpenCommand(String var1);

    public String executeCommandWithShell(String var1);

    public List<String> executeCommandListWithShell(String var1);

    public List<String> executeCommandListWithShell(List<String> var1);

    public List<String> getMkdirsCommand(String var1);

    public String getFileReadCommand(String var1);

    public String getPrintWorkingDirectoryCommand();

    public String getFileCopyCommand(String var1, String var2);

    public String getFileMoveCommand(String var1, String var2);

    public CommandControl createTextFileWriteCommand(ShellControl var1, String var2, String var3);

    public String getFileDeleteCommand(String var1);

    public String getFileExistsCommand(String var1);

    public String getFileTouchCommand(String var1);

    public String getWhichCommand(String var1);

    public Charset determineCharset(ShellControl var1) throws Exception;

    public NewLine getNewLine();

    public String getId();

    public String getDisplayName();

    public String getExecutable();

    public boolean doesRepeatInput();
}

